;; -*- mode: scheme; coding: utf-8 -*-
;; Copyright © 2017, 2018 Göran Weinholt <goran@weinholt.se>
;; SPDX-License-Identifier: MIT
#!r6rs

;; AArch64 definitions.

(library (machine-code disassembler arm-aarch64)
  (export
    system-registers)
  (import
    (rnrs (6)))

  (define system-registers
    '(
      ;;; Debug system registers
      (      OSDTRRX_EL1  2  0  0  0  2)
      (      MDCCINT_EL1  2  0  0  2  0)
      (        MDSCR_EL1  2  0  0  2  2)
      (      OSDTRTX_EL1  2  0  0  3  2)
      (       OSECCR_EL1  2  0  0  6  2)
      (      DBGBVR0_EL1  2  0  0  0  4)
      (      DBGBVR1_EL1  2  0  0  1  4)
      (      DBGBVR2_EL1  2  0  0  2  4)
      (      DBGBVR3_EL1  2  0  0  3  4)
      (      DBGBVR4_EL1  2  0  0  4  4)
      (      DBGBVR5_EL1  2  0  0  5  4)
      (      DBGBVR6_EL1  2  0  0  6  4)
      (      DBGBVR7_EL1  2  0  0  7  4)
      (      DBGBCR0_EL1  2  0  0  0  5)
      (      DBGBCR1_EL1  2  0  0  1  5)
      (      DBGBCR2_EL1  2  0  0  2  5)
      (      DBGBCR3_EL1  2  0  0  3  5)
      (      DBGBCR4_EL1  2  0  0  4  5)
      (      DBGBCR5_EL1  2  0  0  5  5)
      (      DBGBCR6_EL1  2  0  0  6  5)
      (      DBGBCR7_EL1  2  0  0  7  5)
      (      DBGWVR0_EL1  2  0  0  0  6)
      (      DBGWVR1_EL1  2  0  0  1  6)
      (      DBGWVR2_EL1  2  0  0  2  6)
      (      DBGWVR3_EL1  2  0  0  3  6)
      (      DBGWVR4_EL1  2  0  0  4  6)
      (      DBGWVR5_EL1  2  0  0  5  6)
      (      DBGWVR6_EL1  2  0  0  6  6)
      (      DBGWVR7_EL1  2  0  0  7  6)
      (      DBGWCR0_EL1  2  0  0  0  7)
      (      DBGWCR1_EL1  2  0  0  1  7)
      (      DBGWCR2_EL1  2  0  0  2  7)
      (      DBGWCR3_EL1  2  0  0  3  7)
      (      DBGWCR4_EL1  2  0  0  4  7)
      (      DBGWCR5_EL1  2  0  0  5  7)
      (      DBGWCR6_EL1  2  0  0  6  7)
      (      DBGWCR7_EL1  2  0  0  7  7)
      (        MDRAR_EL1  2  0  1  0  0)
      (        OSLAR_EL1  2  0  1  0  4)
      (        OSLSR_EL1  2  0  1  1  4)
      (        OSDLR_EL1  2  0  1  3  4)
      (      DBGPRCR_EL1  2  0  1  4  4)
      (  DBGCLAIMSET_EL1  2  0  7  8  6)
      (  DBGCLAIMCLR_EL1  2  0  7  9  6)
      (DBGAUTHSTATUS_EL1  2  0  7 14  6)
      (       MDCCSR_EL0  2  3  0  1  0)
      (       DBGDTR_EL0  2  3  0  4  0)
      (     DBGDTRRX_EL0  2  3  0  5  0)
      (     DBGDTRTX_EL0  2  3  0  5  0)
      (     DBGVCR32_EL2  2  4  0  7  0)
      ;;; Non-debug system registers
      (         MIDR_EL1  3  0  0  0  0)
      (        MPIDR_EL1  3  0  0  0  5)
      (       REVIDR_EL1  3  0  0  0  6)
      (      ID_PFR0_EL1  3  0  0  1  0)
      (      ID_PFR1_EL1  3  0  0  1  1)
      (      ID_DFR0_EL1  3  0  0  1  2)
      (      ID_AFR0_EL1  3  0  0  1  3)
      (     ID_MMFR0_EL1  3  0  0  1  4)
      (     ID_MMFR1_EL1  3  0  0  1  5)
      (     ID_MMFR2_EL1  3  0  0  1  6)
      (     ID_MMFR3_EL1  3  0  0  1  7)
      (     ID_ISAR0_EL1  3  0  0  2  0)
      (     ID_ISAR1_EL1  3  0  0  2  1)
      (     ID_ISAR2_EL1  3  0  0  2  2)
      (     ID_ISAR3_EL1  3  0  0  2  3)
      (     ID_ISAR4_EL1  3  0  0  2  4)
      (     ID_ISAR5_EL1  3  0  0  2  5)
      (     ID_MMFR4_EL1  3  0  0  2  6)
      (        MVFR0_EL1  3  0  0  3  0)
      (        MVFR1_EL1  3  0  0  3  1)
      (        MVFR2_EL1  3  0  0  3  2)
      (  ID_AA64PFR0_EL1  3  0  0  4  0)
      (  ID_AA64PFR1_EL1  3  0  0  4  1)
      (  ID_AA64DFR0_EL1  3  0  0  5  0)
      (  ID_AA64DFR1_EL1  3  0  0  5  1)
      (  ID_AA64AFR0_EL1  3  0  0  5  4)
      (  ID_AA64AFR1_EL1  3  0  0  5  5)
      ( ID_AA64ISAR0_EL1  3  0  0  6  0)
      ( ID_AA64ISAR1_EL1  3  0  0  6  1)
      ( ID_AA64MMFR0_EL1  3  0  0  7  0)
      ( ID_AA64MMFR1_EL1  3  0  0  7  1)
      (        SCTLR_EL1  3  0  1  0  0)
      (        ACTLR_EL1  3  0  1  0  1)
      (        CPACR_EL1  3  0  1  0  2)
      (        TTBR0_EL1  3  0  2  0  0)
      (        TTBR1_EL1  3  0  2  0  1)
      (          TCR_EL1  3  0  2  0  2)
      (      ICC_PMR_EL1  3  0  4  6  0)
      (      ICV_PMR_EL1  3  0  4  6  0)
      (        AFSR0_EL1  3  0  5  1  0)
      (        AFSR1_EL1  3  0  5  1  1)
      (          ESR_EL1  3  0  5  2  0)
      (          FAR_EL1  3  0  6  0  0)
      (          PAR_EL1  3  0  7  4  0)
      (   PMINTENSET_EL1  3  0  9 14  1)
      (   PMINTENCLR_EL1  3  0  9 14  2)
      (         MAIR_EL1  3  0 10  2  0)
      (        AMAIR_EL1  3  0 10  3  0)
      (         VBAR_EL1  3  0 12  0  0)
      (        RVBAR_EL1  3  0 12  0  1)
      (          RMR_EL1  3  0 12  0  2)
      (          ISR_EL1  3  0 12  1  0)
      (     ICC_IAR0_EL1  3  0 12  8  0)
      (     ICV_IAR0_EL1  3  0 12  8  0)
      (    ICC_EOIR0_EL1  3  0 12  8  1)
      (    ICV_EOIR0_EL1  3  0 12  8  1)
      (   ICC_HPPIR0_EL1  3  0 12  8  2)
      (   ICV_HPPIR0_EL1  3  0 12  8  2)
      (     ICC_BPR0_EL1  3  0 12  8  3)
      (     ICV_BPR0_EL1  3  0 12  8  3)
      (    ICC_AP0R0_EL1  3  0 12  8  4)
      (    ICC_AP0R1_EL1  3  0 12  8  5)
      (    ICC_AP0R2_EL1  3  0 12  8  6)
      (    ICC_AP0R3_EL1  3  0 12  8  7)
      (    ICV_AP0R0_EL1  3  0 12  8  4)
      (    ICV_AP0R1_EL1  3  0 12  8  5)
      (    ICV_AP0R2_EL1  3  0 12  8  6)
      (    ICV_AP0R3_EL1  3  0 12  8  7)
      (    ICC_AP1R0_EL1  3  0 12  9  0)
      (    ICC_AP1R1_EL1  3  0 12  9  1)
      (    ICC_AP1R2_EL1  3  0 12  9  2)
      (    ICC_AP1R3_EL1  3  0 12  9  3)
      (    ICV_AP1R0_EL1  3  0 12  9  0)
      (    ICV_AP1R1_EL1  3  0 12  9  1)
      (    ICV_AP1R2_EL1  3  0 12  9  2)
      (    ICV_AP1R3_EL1  3  0 12  9  3)
      (      ICC_DIR_EL1  3  0 12 11  1)
      (      ICV_DIR_EL1  3  0 12 11  1)
      (      ICC_RPR_EL1  3  0 12 11  3)
      (      ICV_RPR_EL1  3  0 12 11  3)
      (    ICC_SGI1R_EL1  3  0 12 11  5)
      (   ICC_ASGI1R_EL1  3  0 12 11  6)
      (    ICC_SGI0R_EL1  3  0 12 11  7)
      (     ICC_IAR1_EL1  3  0 12 12  0)
      (     ICV_IAR1_EL1  3  0 12 12  0)
      (    ICC_EOIR1_EL1  3  0 12 12  1)
      (    ICV_EOIR1_EL1  3  0 12 12  1)
      (   ICC_HPPIR1_EL1  3  0 12 12  2)
      (   ICV_HPPIR1_EL1  3  0 12 12  2)
      (     ICC_BPR1_EL1  3  0 12 12  3)
      (     ICV_BPR1_EL1  3  0 12 12  3)
      (     ICC_CTLR_EL1  3  0 12 12  4)
      (     ICV_CTLR_EL1  3  0 12 12  4)
      (      ICC_SRE_EL1  3  0 12 12  5)
      (  ICC_IGRPEN0_EL1  3  0 12 12  6)
      (  ICC_IGRPEN1_EL1  3  0 12 12  7)
      (  ICC_IGRPEN0_EL1  3  0 12 12  6)
      (  ICV_IGRPEN0_EL1  3  0 12 12  6)
      (  ICC_IGRPEN1_EL1  3  0 12 12  7)
      (  ICV_IGRPEN1_EL1  3  0 12 12  7)
      (   CONTEXTIDR_EL1  3  0 13  0  1)
      (        TPIDR_EL1  3  0 13  0  4)
      (      CNTKCTL_EL1  3  0 14  1  0)
      (       CCSIDR_EL1  3  1  0  0  0)
      (        CLIDR_EL1  3  1  0  0  1)
      (         AIDR_EL1  3  1  0  0  7)
      (       CSSELR_EL1  3  2  0  0  0)
      (          CTR_EL0  3  3  0  0  1)
      (        DCZID_EL0  3  3  0  0  7)
      (         PMCR_EL0  3  3  9 12  0)
      (   PMCNTENSET_EL0  3  3  9 12  1)
      (   PMCNTENCLR_EL0  3  3  9 12  2)
      (     PMOVSCLR_EL0  3  3  9 12  3)
      (      PMSWINC_EL0  3  3  9 12  4)
      (       PMSELR_EL0  3  3  9 12  5)
      (      PMCEID0_EL0  3  3  9 12  6)
      (      PMCEID1_EL0  3  3  9 12  7)
      (      PMCCNTR_EL0  3  3  9 13  0)
      (   PMXEVTYPER_EL0  3  3  9 13  1)
      (    PMXEVCNTR_EL0  3  3  9 13  2)
      (    PMUSERENR_EL0  3  3  9 14  0)
      (     PMOVSSET_EL0  3  3  9 14  3)
      (        TPIDR_EL0  3  3 13  0  2)
      (      TPIDRRO_EL0  3  3 13  0  3)
      (       CNTFRQ_EL0  3  3 14  0  0)
      (       CNTPCT_EL0  3  3 14  0  1)
      (       CNTVCT_EL0  3  3 14  0  2)
      (    CNTP_TVAL_EL0  3  3 14  2  0)
      (     CNTP_CTL_EL0  3  3 14  2  1)
      (    CNTP_CVAL_EL0  3  3 14  2  2)
      (    CNTV_TVAL_EL0  3  3 14  3  0)
      (     CNTV_CTL_EL0  3  3 14  3  1)
      (    CNTV_CVAL_EL0  3  3 14  3  2)
      (    PMEVCNTR0_EL0  3  3 14  8  0)
      (    PMEVCNTR1_EL0  3  3 14  8  1)
      (    PMEVCNTR2_EL0  3  3 14  8  2)
      (    PMEVCNTR3_EL0  3  3 14  8  3)
      (    PMEVCNTR4_EL0  3  3 14  8  4)
      (    PMEVCNTR5_EL0  3  3 14  8  5)
      (    PMEVCNTR6_EL0  3  3 14  8  6)
      (    PMEVCNTR7_EL0  3  3 14  8  7)
      (    PMEVCNTR8_EL0  3  3 14  9  0)
      (    PMEVCNTR9_EL0  3  3 14  9  1)
      (   PMEVCNTR10_EL0  3  3 14  9  2)
      (   PMEVCNTR11_EL0  3  3 14  9  3)
      (   PMEVCNTR12_EL0  3  3 14  9  4)
      (   PMEVCNTR13_EL0  3  3 14  9  5)
      (   PMEVCNTR14_EL0  3  3 14  9  6)
      (   PMEVCNTR15_EL0  3  3 14  9  7)
      (   PMEVCNTR16_EL0  3  3 14 10  0)
      (   PMEVCNTR17_EL0  3  3 14 10  1)
      (   PMEVCNTR18_EL0  3  3 14 10  2)
      (   PMEVCNTR19_EL0  3  3 14 10  3)
      (   PMEVCNTR20_EL0  3  3 14 10  4)
      (   PMEVCNTR21_EL0  3  3 14 10  5)
      (   PMEVCNTR22_EL0  3  3 14 10  6)
      (   PMEVCNTR23_EL0  3  3 14 10  7)
      (   PMEVCNTR24_EL0  3  3 14 11  0)
      (   PMEVCNTR25_EL0  3  3 14 11  1)
      (   PMEVCNTR26_EL0  3  3 14 11  2)
      (   PMEVCNTR27_EL0  3  3 14 11  3)
      (   PMEVCNTR28_EL0  3  3 14 11  4)
      (   PMEVCNTR29_EL0  3  3 14 11  5)
      (   PMEVCNTR30_EL0  3  3 14 11  6)
      (   PMEVTYPER0_EL0  3  3 14 12  0)
      (   PMEVTYPER1_EL0  3  3 14 12  1)
      (   PMEVTYPER2_EL0  3  3 14 12  2)
      (   PMEVTYPER3_EL0  3  3 14 12  3)
      (   PMEVTYPER4_EL0  3  3 14 12  4)
      (   PMEVTYPER5_EL0  3  3 14 12  5)
      (   PMEVTYPER6_EL0  3  3 14 12  6)
      (   PMEVTYPER7_EL0  3  3 14 12  7)
      (   PMEVTYPER8_EL0  3  3 14 13  0)
      (   PMEVTYPER9_EL0  3  3 14 13  1)
      (  PMEVTYPER10_EL0  3  3 14 13  2)
      (  PMEVTYPER11_EL0  3  3 14 13  3)
      (  PMEVTYPER12_EL0  3  3 14 13  4)
      (  PMEVTYPER13_EL0  3  3 14 13  5)
      (  PMEVTYPER14_EL0  3  3 14 13  6)
      (  PMEVTYPER15_EL0  3  3 14 13  7)
      (  PMEVTYPER16_EL0  3  3 14 14  0)
      (  PMEVTYPER17_EL0  3  3 14 14  1)
      (  PMEVTYPER18_EL0  3  3 14 14  2)
      (  PMEVTYPER19_EL0  3  3 14 14  3)
      (  PMEVTYPER20_EL0  3  3 14 14  4)
      (  PMEVTYPER21_EL0  3  3 14 14  5)
      (  PMEVTYPER22_EL0  3  3 14 14  6)
      (  PMEVTYPER23_EL0  3  3 14 14  7)
      (  PMEVTYPER24_EL0  3  3 14 15  0)
      (  PMEVTYPER25_EL0  3  3 14 15  1)
      (  PMEVTYPER26_EL0  3  3 14 15  2)
      (  PMEVTYPER27_EL0  3  3 14 15  3)
      (  PMEVTYPER28_EL0  3  3 14 15  4)
      (  PMEVTYPER29_EL0  3  3 14 15  5)
      (  PMEVTYPER30_EL0  3  3 14 15  6)
      (    PMCCFILTR_EL0  3  3 14 15  7)
      (        VPIDR_EL2  3  4  0  0  0)
      (       VMPIDR_EL2  3  4  0  0  5)
      (        SCTLR_EL2  3  4  1  0  0)
      (        ACTLR_EL2  3  4  1  0  1)
      (          HCR_EL2  3  4  1  1  0)
      (         MDCR_EL2  3  4  1  1  1)
      (         CPTR_EL2  3  4  1  1  2)
      (         HSTR_EL2  3  4  1  1  3)
      (         HACR_EL2  3  4  1  1  7)
      (        TTBR0_EL2  3  4  2  0  0)
      (          TCR_EL2  3  4  2  0  2)
      (        VTTBR_EL2  3  4  2  1  0)
      (         VTCR_EL2  3  4  2  1  2)
      (       DACR32_EL2  3  4  3  0  0)
      (       IFSR32_EL2  3  4  5  0  1)
      (        AFSR0_EL2  3  4  5  1  0)
      (        AFSR1_EL2  3  4  5  1  1)
      (          ESR_EL2  3  4  5  2  0)
      (      FPEXC32_EL2  3  4  5  3  0)
      (          FAR_EL2  3  4  6  0  0)
      (        HPFAR_EL2  3  4  6  0  4)
      (         MAIR_EL2  3  4 10  2  0)
      (        AMAIR_EL2  3  4 10  3  0)
      (         VBAR_EL2  3  4 12  0  0)
      (        RVBAR_EL2  3  4 12  0  1)
      (          RMR_EL2  3  4 12  0  2)
      (    ICH_AP0R0_EL2  3  4 12  8  0)
      (    ICH_AP0R1_EL2  3  4 12  8  1)
      (    ICH_AP0R2_EL2  3  4 12  8  2)
      (    ICH_AP0R3_EL2  3  4 12  8  3)
      (    ICH_AP1R0_EL2  3  4 12  9  0)
      (    ICH_AP1R1_EL2  3  4 12  9  1)
      (    ICH_AP1R2_EL2  3  4 12  9  2)
      (    ICH_AP1R3_EL2  3  4 12  9  3)
      (      ICC_SRE_EL2  3  4 12  9  5)
      (      ICH_HCR_EL2  3  4 12 11  0)
      (      ICH_VTR_EL2  3  4 12 11  1)
      (     ICH_MISR_EL2  3  4 12 11  2)
      (     ICH_EISR_EL2  3  4 12 11  3)
      (    ICH_ELRSR_EL2  3  4 12 11  5)
      (     ICH_VMCR_EL2  3  4 12 11  7)
      (      ICH_LR0_EL2  3  4 12 12  0)
      (      ICH_LR1_EL2  3  4 12 12  1)
      (      ICH_LR2_EL2  3  4 12 12  2)
      (      ICH_LR3_EL2  3  4 12 12  3)
      (      ICH_LR4_EL2  3  4 12 12  4)
      (      ICH_LR5_EL2  3  4 12 12  5)
      (      ICH_LR6_EL2  3  4 12 12  6)
      (      ICH_LR7_EL2  3  4 12 12  7)
      (      ICH_LR8_EL2  3  4 12 13  8)
      (      ICH_LR9_EL2  3  4 12 13  9)
      (     ICH_LR10_EL2  3  4 12 13 10)
      (     ICH_LR11_EL2  3  4 12 13 11)
      (     ICH_LR12_EL2  3  4 12 13 12)
      (     ICH_LR13_EL2  3  4 12 13 13)
      (     ICH_LR14_EL2  3  4 12 13 14)
      (     ICH_LR15_EL2  3  4 12 13 15)
      (        TPIDR_EL2  3  4 13  0  2)
      (      CNTVOFF_EL2  3  4 14  0  3)
      (      CNTHCTL_EL2  3  4 14  1  0)
      (   CNTHP_TVAL_EL2  3  4 14  2  0)
      (    CNTHP_CTL_EL2  3  4 14  2  1)
      (   CNTHP_CVAL_EL2  3  4 14  2  2)
      (        SCTLR_EL3  3  6  1  0  0)
      (        ACTLR_EL3  3  6  1  0  1)
      (          SCR_EL3  3  6  1  1  0)
      (       SDER32_EL3  3  6  1  1  1)
      (         CPTR_EL3  3  6  1  1  2)
      (         MDCR_EL3  3  6  1  3  1)
      (        TTBR0_EL3  3  6  2  0  0)
      (          TCR_EL3  3  6  2  0  2)
      (        AFSR0_EL3  3  6  5  1  0)
      (        AFSR1_EL3  3  6  5  1  1)
      (          ESR_EL3  3  6  5  2  0)
      (          FAR_EL3  3  6  6  0  0)
      (         MAIR_EL3  3  6 10  2  0)
      (        AMAIR_EL3  3  6 10  3  0)
      (         VBAR_EL3  3  6 12  0  0)
      (        RVBAR_EL3  3  6 12  0  1)
      (          RMR_EL3  3  6 12  0  2)
      (     ICC_CTLR_EL3  3  6 12 12  4)
      (      ICC_SRE_EL3  3  6 12 12  5)
      (  ICC_IGRPEN1_EL3  3  6 12 12  7)
      (        TPIDR_EL3  3  6 13  0  2)
      (   CNTPS_TVAL_EL1  3  7 14  2  0)
      (    CNTPS_CTL_EL1  3  7 14  2  1)
      (   CNTPS_CVAL_EL1  3  7 14  2  2)
      ;;; Special-purpose registers
      (         SPSR_EL1  3  0  4  0  0)
      (          ELR_EL1  3  0  4  0  1)
      (           SP_EL0  3  0  4  1  0)
      (            SPSel  3  0  4  2  0)
      (        CurrentEL  3  0  4  2  2)
      (             DAIF  3  3  4  2  1)
      (             NZCV  3  3  4  2  0)
      (             FPCR  3  3  4  4  0)
      (             FPSR  3  3  4  4  1)
      (        DSPSR_EL0  3  3  4  5  0)
      (          DLR_EL0  3  3  4  5  1)
      (         SPSR_EL2  3  4  4  0  0)
      (          ELR_EL2  3  4  4  0  1)
      (           SP_EL1  3  4  4  1  0)
      (         SPSR_irq  3  4  4  3  0)
      (         SPSR_abt  3  4  4  3  1)
      (         SPSR_und  3  4  4  3  2)
      (         SPSR_fiq  3  4  4  3  3)
      (         SPSR_EL3  3  6  4  0  0)
      (          ELR_EL3  3  6  4  0  1)
      (           SP_EL2  3  6  4  1  0))))
