<!--
SPDX-FileCopyrightText: 2022 G. Weinholt

SPDX-License-Identifier: EUPL-1.2+
-->

# Submitting code

Contributions are accepted under the terms of the EUPL, the main
license of the project.

Use one of these options:

1. Open a merge request on GitLab (https://gitlab.com/weinholt/loko); or

2. Push your code to any public git repository and
   email [bugs@scheme.fail](mailto:bugs@scheme.fail) asking for a
   branch to be merged; or

3. Use `git format-patch` and email it
   to [bugs@scheme.fail](mailto:bugs@scheme.fail).

This project follows
the [REUSE specification](https://reuse.software/). Please run `reuse
lint` on your work with a recent (>2022-02) copy of the reuse tool.

If you want to share something smallish that doesn't really belong
anywhere then you can add it to the `contrib/` directory.

# Issues

There may be an issue tracker at <https://gitlab.com/weinholt/loko>,
but please instead use channels where issues nobody cares about can be
lost in the mists of time.
