;; -*- mode: scheme; coding: utf-8 -*-
;; SPDX-License-Identifier: EUPL-1.2+
;; This file is a part of Loko Scheme, an R6RS Scheme system
;; Copyright © 2019, 2020 Gwen Weinholt
#!r6rs

;;; Closure conversion

(library (loko compiler closure)
  (export pass-closure)
  (import
    (loko compiler recordize)
    (rename (loko runtime utils) (map-in-order map))
    (except (rnrs) map)
    (only (psyntax compat) gensym))

(define (pass-closure top-level-name x)
  (define who 'pass-closure)
  (define labels '())
  (define (pass x)
    ;; (display x)
    ;; (newline)
    (cond ((bind? x)
           (make-bind (bind-lhs* x)
                      (map pass (bind-rhs* x))
                      (pass (bind-body x))))
          ((fix? x)
           (make-fix (fix-lhs* x)
                     (map pass (fix-rhs* x))
                     (pass (fix-body x))))
          ((proc? x)
           (let ((proc (make-proc (proc-label x)
                                  (proc-end-label x)
                                  (map (lambda (x)
                                         (make-proccase (proccase-info x)
                                                        (pass (proccase-body x))))
                                       (proc-cases x))
                                  (proc-free x)
                                  (proc-name x)
                                  (proc-source x)
                                  (and (proc-tag x) #t))))
             (set! labels (cons proc labels))
             (make-closure proc (proc-free x)
                           (cond ((proc-tag x) => pass)
                                 (else (make-const #f #f))))))

          ((seq? x)
           (make-seq (pass (seq-e0 x))
                     (pass (seq-e1 x))))
          ((mutate? x)
           (make-mutate (mutate-name x)
                        (pass (mutate-expr x))))
          ((test? x)
           (make-test (pass (test-expr x))
                      (pass (test-then x))
                      (pass (test-else x))))
          ((funcall? x)
           (let ((op (funcall-operator x))
                 (operands (funcall-operand* x)))
             (make-funcall (pass op)
                           (map pass operands)
                           (funcall-label x)
                           (funcall-source x))))
          ((mv-call? x)
           (make-mv-call (pass (mv-call-producer x))
                         (pass (mv-call-consumer x))
                         (mv-call-source x)))
          ((mv-let? x)
           (make-mv-let (pass (mv-let-expr x))
                        (mv-let-lhs* x)
                        (pass (mv-let-body x))
                        (mv-let-source x)))
          ((mv-values? x)
           (make-mv-values (map pass (mv-values-expr* x))
                           (mv-values-source x)))
          ((const? x) x)
          ((ref? x) x)
          ((primref? x) x)
          ((goto? x) x)
          ((tagbody? x)
           (make-tagbody (tagbody-label x)
                         (pass (tagbody-body x))
                         (tagbody-source x)))
          ((infer? x)
           (make-infer (pass (infer-expr x))
                       (infer-facts x)))
          (else
           (error who "Unknown type" x))))
  (let ((body (pass x)))
    (make-labels top-level-name labels body))))
