# Version 0.5.0

With this version only a single test in the Racket R6RS test suite
fails. There should be no incompatibilities with previous versions.
Here are some of the improvements:

* The `module` syntax is exported in the `(loko)` module, allowing the
  definition of internal modules. This is provided for compatibility
  with existing code.

* The `(rnrs unicode)` library is now completely implemented thanks to
  the use of the R6RS unicode implementation by Abdulaziz Ghuloum and
  R. Kent Dybvig.

* The `(rnrs io ports)` library has received a significant speed
  boost.

* Improved support for multiple return values. Up to six return values
  can be passed directly in registers.

* Loko now uses [laesare](https://akkuscm.org/packages/laesare/) as
  its reader. This means that line and column information is available
  on assertions and procedures. This reader also supports the R7RS
  lexical syntax.

* Loko now checks variable references in `letrec` and `letrec*` to
  ensure that variables are not used before they are defined.

* The .bss section is now generated correctly, so Linux perf is now
  willing to use the symbol table.

* The `bin/pc-repl` program is a new graphical REPL that currently
  runs on virtual machines.

* `map` is now tail recursive and does not build up a large stack,
  which fixes a pathological case in some programs that use `call/cc`
  from inside map.

See git for a full list of changes.
