;; -*- mode: scheme; coding: utf-8 -*-
;; SPDX-License-Identifier: AGPL-3.0-or-later
;; Loko Scheme - an R6RS Scheme compiler
;; Copyright © 2019, 2020, 2021 Göran Weinholt

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU Affero General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU Affero General Public License for more details.

;; You should have received a copy of the GNU Affero General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
#!r6rs

;;; Memory-related constants and such

(library (loko arch amd64 memory)
  (export
    STACK-0-START STACK-0-SIZE
    HEAP-0-START HEAP-0-SIZE
    HEAP-MARGIN
    PAGE-SIZE)
  (import
    (rnrs (6)))

(define K 1024)
(define M (* 1024 K))
(define G (* 1024 M))
(define T (* 1024 G))
(define PAGE-SIZE (* 4 K))
(define CODE-TOP (* 4 G))
(define HEAP-MARGIN (* 128 K))

;; Stack and heap for process 0. This is the process that gets started
;; by the entry point of the executable image, i.e. the scheduler
;; process on the first CPU/thread.
(define STACK-0-START (* 1 T))
(define STACK-0-SIZE  (* 2 M))
(define HEAP-0-START  (+ STACK-0-START STACK-0-SIZE))
(define HEAP-0-SIZE   (* 16 M)))
