;; -*- mode: scheme; coding: utf-8 -*-
;; SPDX-License-Identifier: AGPL-3.0-or-later
;; Loko Scheme - an R6RS Scheme compiler
;; Copyright © 2019-2021 Göran Weinholt

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU Affero General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU Affero General Public License for more details.

;; You should have received a copy of the GNU Affero General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
#!r6rs

;;; Compiler-level interface towards psyntax

;; This code is based on the makefile from r6rs-libraries, which
;; carried this notice:

;; Copyright (c) 2006, 2007 Abdulaziz Ghuloum and Kent Dybvig
;;
;; Permission is hereby granted, free of charge, to any person obtaining a
;; copy of this software and associated documentation files (the "Software"),
;; to deal in the Software without restriction, including without limitation
;; the rights to use, copy, modify, merge, publish, distribute, sublicense,
;; and/or sell copies of the Software, and to permit persons to whom the
;; Software is furnished to do so, subject to the following conditions:
;;
;; The above copyright notice and this permission notice shall be included in
;; all copies or substantial portions of the Software.
;;
;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
;; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
;; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
;; DEALINGS IN THE SOFTWARE.

(library (loko compiler expander)
  (export
    expand-files)
  (import
    (rnrs arithmetic bitwise)
    (rename (loko runtime utils) (map-in-order map))
    (except (rnrs base) map)
    (rnrs arithmetic fixnums)
    (rnrs bytevectors)
    (rnrs control)
    (rnrs hashtables)
    (rnrs programs)
    (rnrs io simple)
    (rnrs io ports)
    (rnrs lists)
    (rnrs files)
    (rnrs unicode)
    (psyntax internal)
    (psyntax compat)
    (psyntax library-manager)
    (psyntax expander)
    (loko config))

(define psyntax-system-macros
  '((define              (define))
    (define-syntax       (define-syntax))
    (module              (module))
    (library             (library))
    (define-library      (define-library))
    (begin               (begin))
    (import              (import))
    (set!                (set!))
    (let-syntax          (let-syntax))
    (letrec-syntax       (letrec-syntax))
    ;; (foreign-call        (core-macro . foreign-call))
    (quote               (core-macro . quote))
    (syntax-case         (core-macro . syntax-case))
    (syntax              (core-macro . syntax))
    (lambda              (core-macro . lambda))
    (case-lambda         (core-macro . case-lambda))
    (type-descriptor     (core-macro . type-descriptor))
    (letrec              (core-macro . letrec))
    (letrec*             (core-macro . letrec*))
    (if                  (core-macro . if))
    (qq                  (core-macro . qq))
    (record-type-descriptor (core-macro . record-type-descriptor))
    (record-constructor-descriptor (core-macro . record-constructor-descriptor))
    (define-struct       (macro . define-struct))
    (include             (macro . include))
    (include/resolve     (macro . include/resolve))
    (include/r7rs        (macro . include/r7rs))
    (syntax-rules        (macro . syntax-rules))
    (quasiquote          (macro . quasiquote))
    (quasisyntax         (macro . quasisyntax))
    (with-syntax         (macro . with-syntax))
    (identifier-syntax   (macro . identifier-syntax))
    (parameterize        (macro . parameterize))
    (when                (macro . when))
    (unless              (macro . unless))
    (case                (macro . case))
    (let-values          (macro . let-values))
    (let*-values         (macro . let*-values))
    (let                 (macro . let))
    (let*                (macro . let*))
    (cond                (macro . cond))
    (do                  (macro . do))
    (and                 (macro . and))
    (or                  (macro . or))
    (time                (macro . time))
    (delay               (macro . delay))
    (endianness          (macro . endianness))
    (assert              (macro . assert))
    (...                 (macro . ...))
    (=>                  (macro . =>))
    (else                (macro . else))
    (_                   (macro . _))
    (unquote             (macro . unquote))
    (unquote-splicing    (macro . unquote-splicing))
    (unsyntax            (macro . unsyntax))
    (unsyntax-splicing   (macro . unsyntax-splicing))
    (trace-lambda        (macro . trace-lambda))
    (trace-define        (macro . trace-define))
    ;;; new
    (guard                 (macro . guard))
    (eol-style             (macro . eol-style))
    (buffer-mode           (macro . buffer-mode))
    (file-options          (macro . file-options))
    (error-handling-mode   (macro . error-handling-mode))
    (fields                (macro . fields))
    (mutable               (macro . mutable))
    (immutable             (macro . immutable))
    (parent                (macro . parent))
    (protocol              (macro . protocol))
    (sealed                (macro . sealed))
    (opaque                (macro . opaque ))
    (nongenerative         (macro . nongenerative))
    (parent-rtd            (macro . parent-rtd))
    (define-record-type    (macro . define-record-type))
    (define-enumeration    (macro . define-enumeration))
    (define-condition-type (macro . define-condition-type))
    ;;; for (record-type-descriptor &condition-type) and
    ;;; (record-constructor-descriptor &condition-type) to
    ;;; expand properly, the implementation must export
    ;;; the identifiers &condition-type-rtd, which must
    ;;; be bound to the run-time value of the rtd, and
    ;;; &condition-type-rcd which must be bound to the
    ;;; corresponding record-constructor-descriptor.
    (&condition                ($core-rtd . (&condition-rtd &condition-rcd)))
    (&message                  ($core-rtd . (&message-rtd &message-rcd)))
    (&warning                  ($core-rtd . (&warning-rtd &warning-rcd )))
    (&serious                  ($core-rtd . (&serious-rtd &serious-rcd)))
    (&error                    ($core-rtd . (&error-rtd &error-rcd)))
    (&violation                ($core-rtd . (&violation-rtd &violation-rcd)))
    (&assertion                ($core-rtd . (&assertion-rtd &assertion-rcd)))
    (&irritants                ($core-rtd . (&irritants-rtd &irritants-rcd)))
    (&who                      ($core-rtd . (&who-rtd &who-rcd)))
    (&non-continuable          ($core-rtd . (&non-continuable-rtd &non-continuable-rcd)))
    (&implementation-restriction  ($core-rtd . (&implementation-restriction-rtd &implementation-restriction-rcd)))
    (&lexical                  ($core-rtd . (&lexical-rtd &lexical-rcd)))
    (&syntax                   ($core-rtd . (&syntax-rtd &syntax-rcd)))
    (&undefined                ($core-rtd . (&undefined-rtd &undefined-rcd)))
    (&i/o                      ($core-rtd . (&i/o-rtd &i/o-rcd)))
    (&i/o-read                 ($core-rtd . (&i/o-read-rtd &i/o-read-rcd)))
    (&i/o-write                ($core-rtd . (&i/o-write-rtd &i/o-write-rcd)))
    (&i/o-invalid-position     ($core-rtd . (&i/o-invalid-position-rtd &i/o-invalid-position-rcd)))
    (&i/o-filename             ($core-rtd . (&i/o-filename-rtd &i/o-filename-rcd)))
    (&i/o-file-protection      ($core-rtd . (&i/o-file-protection-rtd &i/o-file-protection-rcd)))
    (&i/o-file-is-read-only    ($core-rtd . (&i/o-file-is-read-only-rtd &i/o-file-is-read-only-rcd)))
    (&i/o-file-already-exists  ($core-rtd . (&i/o-file-already-exists-rtd &i/o-file-already-exists-rcd)))
    (&i/o-file-does-not-exist  ($core-rtd . (&i/o-file-does-not-exist-rtd &i/o-file-does-not-exist-rcd)))
    (&i/o-port                 ($core-rtd . (&i/o-port-rtd &i/o-port-rcd)))
    (&i/o-decoding             ($core-rtd . (&i/o-decoding-rtd &i/o-decoding-rcd)))
    (&i/o-encoding             ($core-rtd . (&i/o-encoding-rtd &i/o-encoding-rcd)))
    (&no-infinities            ($core-rtd . (&no-infinities-rtd &no-infinities-rcd)))
    (&no-nans                  ($core-rtd . (&no-nans-rtd &no-nans-rcd)))
    ))

(define (macro-identifier x)
  (assq x psyntax-system-macros))

;; m is relevant for (base-of-interaction-library) in config.ss.

(define library-legend
  ;; abbr.       name                             visible? required?
  '(#;(interaction (ikarus interaction)                  #t    #f)
    (^           (loko)                                #f    #t)
    (ne          (psyntax null-environment-5)          #t    #f)
    (se          (psyntax scheme-report-environment-5) #t    #f)
    (cm          (psyntax modules)                     #t    #f)
    (r           (rnrs)                                #t    #t)
    (r5          (rnrs r5rs)                           #t    #t)
    (ct          (rnrs control)                        #t    #t)
    (ev          (rnrs eval)                           #t    #t)
    (mp          (rnrs mutable-pairs)                  #t    #t)
    (ms          (rnrs mutable-strings)                #t    #t)
    (pr          (rnrs programs)                       #t    #t)
    (sc          (rnrs syntax-case)                    #t    #t)
    (fi          (rnrs files)                          #t    #t)
    (sr          (rnrs sorting)                        #t    #t)
    (ba          (rnrs base)                           #t    #t)
    (ls          (rnrs lists)                          #t    #t)
    (is          (rnrs io simple)                      #t    #t)
    (bv          (rnrs bytevectors)                    #t    #t)
    (uc          (rnrs unicode)                        #t    #t)
    (ex          (rnrs exceptions)                     #t    #t)
    (bw          (rnrs arithmetic bitwise)             #t    #t)
    (fx          (rnrs arithmetic fixnums)             #t    #t)
    (fl          (rnrs arithmetic flonums)             #t    #t)
    (ht          (rnrs hashtables)                     #t    #t)
    (ip          (rnrs io ports)                       #t    #t)
    (en          (rnrs enums)                          #t    #t)
    (co          (rnrs conditions)                     #t    #t)
    (ri          (rnrs records inspection)             #t    #t)
    (rp          (rnrs records procedural)             #t    #t)
    (rs          (rnrs records syntactic)              #t    #t)
    ($all        (psyntax system $all)                 #f    #t)
    ($boot       (psyntax system $bootstrap)           #f    #t)

    (srfi98      (srfi :98 os-environment-variables)   #t    #t)
    (s98         (srfi :98)                            #t    #t)

    (srfi215     (srfi :215 logging)                   #t    #t)
    (s215        (srfi :215)                           #t    #t)
    (log         (loko system logging)                 #t    #t)

    (time        (loko system time)                    #t    #t)
    (lsu         (loko system unsafe)                  #t    #t)
    (cache       (loko system unsafe cache)            #t    #t)
    (fibers      (loko system fibers)                  #t    #t)
    (fs          (loko system file-system)             #t    #t)
    (r7          (loko system r7rs)                    #t    #t)
    (random      (loko system random)                  #t    #t)

    ($compat     (loko compiler compat)                #t    #t)
    ($p          (loko system $primitives)             #f    #t)
    ($x86        (loko system $x86)                    #f    #t)
    ($host       (loko system $host)                   #f    #t)

    ))

;;; required? flag means that said library is required for
;;; building the system.  The only non-r6rs required libraries
;;; should be (psyntax system $bootstrap) and (psyntax system $all).
;;; (psyntax system $bootstrap) should export, at a minimum, the
;;; following procedures: gensym, symbol-value, set-symbol-value!,
;;; eval-core, and pretty-print.
;;; (psyntax system $all) is fabricated by the system to include
;;; every identifier in the system.


(define identifier->library-map
  '(
    ;;;
    (lambda                                     ^ r ba se ne)
    (and                                        ^ r ba se ne)
    (begin                                      ^ r ba se ne)
    (case                                       ^ r ba se ne)
    (cond                                       ^ r ba se ne)
    (define                                     ^ r ba se ne)
    (define-syntax                              ^ r ba se ne)
    (identifier-syntax                          ^ r ba)
    (if                                         ^ r ba se ne)
    (let                                        ^ r ba se ne)
    (let*                                       ^ r ba se ne)
    (let*-values                                ^ r ba)
    (let-syntax                                 ^ r ba se ne)
    (let-values                                 ^ r ba)
    (letrec                                     ^ r ba se ne)
    (letrec*                                    ^ r ba)
    (letrec-syntax                              ^ r ba se ne)
    (or                                         ^ r ba se ne)
    (quasiquote                                 ^ r ba se ne)
    (quote                                      ^ r ba se ne)
    (set!                                       ^ r ba se ne)
    (syntax-rules                               ^ r ba se ne)
    (unquote                                    ^ r ba se ne)
    (unquote-splicing                           ^ r ba se ne)
    (<                                          ^ r ba se)
    (<=                                         ^ r ba se)
    (=                                          ^ r ba se)
    (>                                          ^ r ba se)
    (>=                                         ^ r ba se)
    (+                                          ^ r ba se)
    (-                                          ^ r ba se)
    (*                                          ^ r ba se)
    (/                                          ^ r ba se)
    (abs                                        ^ r ba se)
    (acos                                       ^ r ba se)
    (angle                                      ^ r ba se)
    (append                                     ^ r ba se)
    (apply                                      ^ r ba se)
    (asin                                       ^ r ba se)
    (assert                                     ^ r ba)
    (assertion-violation                        ^ r ba)
    (atan                                       ^ r ba se)
    (boolean=?                                  ^ r ba)
    (boolean?                                   ^ r ba se)
    (car                                        ^ r ba se)
    (cdr                                        ^ r ba se)
    (caar                                       ^ r ba se)
    (cadr                                       ^ r ba se)
    (cdar                                       ^ r ba se)
    (cddr                                       ^ r ba se)
    (caaar                                      ^ r ba se)
    (caadr                                      ^ r ba se)
    (cadar                                      ^ r ba se)
    (caddr                                      ^ r ba se)
    (cdaar                                      ^ r ba se)
    (cdadr                                      ^ r ba se)
    (cddar                                      ^ r ba se)
    (cdddr                                      ^ r ba se)
    (caaaar                                     ^ r ba se)
    (caaadr                                     ^ r ba se)
    (caadar                                     ^ r ba se)
    (caaddr                                     ^ r ba se)
    (cadaar                                     ^ r ba se)
    (cadadr                                     ^ r ba se)
    (caddar                                     ^ r ba se)
    (cadddr                                     ^ r ba se)
    (cdaaar                                     ^ r ba se)
    (cdaadr                                     ^ r ba se)
    (cdadar                                     ^ r ba se)
    (cdaddr                                     ^ r ba se)
    (cddaar                                     ^ r ba se)
    (cddadr                                     ^ r ba se)
    (cdddar                                     ^ r ba se)
    (cddddr                                     ^ r ba se)
    (call-with-current-continuation             ^ r ba se)
    (call/cc                                    ^ r ba)
    (call-with-values                           ^ r ba se)
    (ceiling                                    ^ r ba se)
    (char->integer                              ^ r ba se)
    (char<=?                                    ^ r ba se)
    (char<?                                     ^ r ba se)
    (char=?                                     ^ r ba se)
    (char>=?                                    ^ r ba se)
    (char>?                                     ^ r ba se)
    (char?                                      ^ r ba se)
    (complex?                                   ^ r ba se)
    (cons                                       ^ r ba se)
    (cos                                        ^ r ba se)
    (denominator                                ^ r ba se)
    (div                                        ^ r ba)
    (mod                                        ^ r ba)
    (div-and-mod                                ^ r ba)
    (div0                                       ^ r ba)
    (mod0                                       ^ r ba)
    (div0-and-mod0                              ^ r ba)
    (dynamic-wind                               ^ r ba se)
    (eq?                                        ^ r ba se)
    (equal?                                     ^ r ba se)
    (eqv?                                       ^ r ba se)
    (error                                      ^ r ba)
    (even?                                      ^ r ba se)
    (exact                                      ^ r ba)
    (exact-integer-sqrt                         ^ r ba)
    (exact?                                     ^ r ba se)
    (exp                                        ^ r ba se)
    (expt                                       ^ r ba se)
    (finite?                                    ^ r ba)
    (floor                                      ^ r ba se)
    (for-each                                   ^ r ba se)
    (gcd                                        ^ r ba se)
    (imag-part                                  ^ r ba se)
    (inexact                                    ^ r ba)
    (inexact?                                   ^ r ba se)
    (infinite?                                  ^ r ba)
    (integer->char                              ^ r ba se)
    (integer-valued?                            ^ r ba)
    (integer?                                   ^ r ba se)
    (lcm                                        ^ r ba se)
    (length                                     ^ r ba se)
    (list                                       ^ r ba se)
    (list->string                               ^ r ba se)
    (list->vector                               ^ r ba se)
    (list-ref                                   ^ r ba se)
    (list-tail                                  ^ r ba se)
    (list?                                      ^ r ba se)
    (log                                        ^ r ba se)
    (magnitude                                  ^ r ba se)
    (make-polar                                 ^ r ba se)
    (make-rectangular                           ^ r ba se)
    (make-string                                ^ r ba se)
    (make-vector                                ^ r ba se)
    (map                                        ^ r ba se)
    (max                                        ^ r ba se)
    (min                                        ^ r ba se)
    (nan?                                       ^ r ba)
    (negative?                                  ^ r ba se)
    (not                                        ^ r ba se)
    (null?                                      ^ r ba se)
    (number->string                             ^ r ba se)
    (number?                                    ^ r ba se)
    (numerator                                  ^ r ba se)
    (odd?                                       ^ r ba se)
    (pair?                                      ^ r ba se)
    (positive?                                  ^ r ba se)
    (procedure?                                 ^ r ba se)
    (rational-valued?                           ^ r ba)
    (rational?                                  ^ r ba se)
    (rationalize                                ^ r ba se)
    (real-part                                  ^ r ba se)
    (real-valued?                               ^ r ba)
    (real?                                      ^ r ba se)
    (reverse                                    ^ r ba se)
    (round                                      ^ r ba se)
    (sin                                        ^ r ba se)
    (sqrt                                       ^ r ba se)
    (string                                     ^ r ba se)
    (string->list                               ^ r ba se)
    (string->number                             ^ r ba se)
    (string->symbol                             ^ r ba se)
    (string-append                              ^ r ba se)
    (string-copy                                ^ r ba se)
    (string-for-each                            ^ r ba)
    (string-length                              ^ r ba se)
    (string-ref                                 ^ r ba se)
    (string<=?                                  ^ r ba se)
    (string<?                                   ^ r ba se)
    (string=?                                   ^ r ba se)
    (string>=?                                  ^ r ba se)
    (string>?                                   ^ r ba se)
    (string?                                    ^ r ba se)
    (substring                                  ^ r ba se)
    (symbol->string                             ^ r ba se)
    (symbol=?                                   ^ r ba)
    (symbol?                                    ^ r ba se)
    (tan                                        ^ r ba se)
    (truncate                                   ^ r ba se)
    (values                                     ^ r ba se)
    (vector                                     ^ r ba se)
    (vector->list                               ^ r ba se)
    (vector-fill!                               ^ r ba se)
    (vector-for-each                            ^ r ba)
    (vector-length                              ^ r ba se)
    (vector-map                                 ^ r ba)
    (vector-ref                                 ^ r ba se)
    (vector-set!                                ^ r ba se)
    (vector?                                    ^ r ba se)
    (zero?                                      ^ r ba se)
    (...                                        ^ ne r ba sc se)
    (=>                                         ^ ne r ba ex se)
    (_                                          ^ ne r ba sc)
    (else                                       ^ ne r ba ex se)
    ;;;
    (bitwise-arithmetic-shift                   ^ r bw)
    (bitwise-arithmetic-shift-left              ^ r bw)
    (bitwise-arithmetic-shift-right             ^ r bw)
    (bitwise-not                                ^ r bw)
    (bitwise-and                                ^ r bw)
    (bitwise-ior                                ^ r bw)
    (bitwise-xor                                ^ r bw)
    (bitwise-bit-count                          ^ r bw)
    (bitwise-bit-field                          ^ r bw)
    (bitwise-bit-set?                           ^ r bw)
    (bitwise-copy-bit                           ^ r bw)
    (bitwise-copy-bit-field                     ^ r bw)
    (bitwise-first-bit-set                      ^ r bw)
    (bitwise-if                                 ^ r bw)
    (bitwise-length                             ^ r bw)
    (bitwise-reverse-bit-field                  ^ r bw)
    (bitwise-rotate-bit-field                   ^ r bw)
    ;;;
    (fixnum?                                    ^ r fx)
    (fixnum-width                               ^ r fx)
    (least-fixnum                               ^ r fx)
    (greatest-fixnum                            ^ r fx)
    (fx*                                        ^ r fx)
    (fx*/carry                                  ^ r fx)
    (fx+                                        ^ r fx)
    (fx+/carry                                  ^ r fx)
    (fx-                                        ^ r fx)
    (fx-/carry                                  ^ r fx)
    (fx<=?                                      ^ r fx)
    (fx<?                                       ^ r fx)
    (fx=?                                       ^ r fx)
    (fx>=?                                      ^ r fx)
    (fx>?                                       ^ r fx)
    (fxand                                      ^ r fx)
    (fxarithmetic-shift                         ^ r fx)
    (fxarithmetic-shift-left                    ^ r fx)
    (fxarithmetic-shift-right                   ^ r fx)
    (fxbit-count                                ^ r fx)
    (fxbit-field                                ^ r fx)
    (fxbit-set?                                 ^ r fx)
    (fxcopy-bit                                 ^ r fx)
    (fxcopy-bit-field                           ^ r fx)
    (fxdiv                                      ^ r fx)
    (fxdiv-and-mod                              ^ r fx)
    (fxdiv0                                     ^ r fx)
    (fxdiv0-and-mod0                            ^ r fx)
    (fxeven?                                    ^ r fx)
    (fxfirst-bit-set                            ^ r fx)
    (fxif                                       ^ r fx)
    (fxior                                      ^ r fx)
    (fxlength                                   ^ r fx)
    (fxmax                                      ^ r fx)
    (fxmin                                      ^ r fx)
    (fxmod                                      ^ r fx)
    (fxmod0                                     ^ r fx)
    (fxnegative?                                ^ r fx)
    (fxnot                                      ^ r fx)
    (fxodd?                                     ^ r fx)
    (fxpositive?                                ^ r fx)
    (fxreverse-bit-field                        ^ r fx)
    (fxrotate-bit-field                         ^ r fx)
    (fxxor                                      ^ r fx)
    (fxzero?                                    ^ r fx)
    ;;;
    (fixnum->flonum                             ^ r fl)
    (fl*                                        ^ r fl)
    (fl+                                        ^ r fl)
    (fl-                                        ^ r fl)
    (fl/                                        ^ r fl)
    (fl<=?                                      ^ r fl)
    (fl<?                                       ^ r fl)
    (fl=?                                       ^ r fl)
    (fl>=?                                      ^ r fl)
    (fl>?                                       ^ r fl)
    (flabs                                      ^ r fl)
    (flacos                                     ^ r fl)
    (flasin                                     ^ r fl)
    (flatan                                     ^ r fl)
    (flceiling                                  ^ r fl)
    (flcos                                      ^ r fl)
    (fldenominator                              ^ r fl)
    (fldiv                                      ^ r fl)
    (fldiv-and-mod                              ^ r fl)
    (fldiv0                                     ^ r fl)
    (fldiv0-and-mod0                            ^ r fl)
    (fleven?                                    ^ r fl)
    (flexp                                      ^ r fl)
    (flexpt                                     ^ r fl)
    (flfinite?                                  ^ r fl)
    (flfloor                                    ^ r fl)
    (flinfinite?                                ^ r fl)
    (flinteger?                                 ^ r fl)
    (fllog                                      ^ r fl)
    (flmax                                      ^ r fl)
    (flmin                                      ^ r fl)
    (flmod                                      ^ r fl)
    (flmod0                                     ^ r fl)
    (flnan?                                     ^ r fl)
    (flnegative?                                ^ r fl)
    (flnumerator                                ^ r fl)
    (flodd?                                     ^ r fl)
    (flonum?                                    ^ r fl)
    (flpositive?                                ^ r fl)
    (flround                                    ^ r fl)
    (flsin                                      ^ r fl)
    (flsqrt                                     ^ r fl)
    (fltan                                      ^ r fl)
    (fltruncate                                 ^ r fl)
    (flzero?                                    ^ r fl)
    (real->flonum                               ^ r fl)
    (make-no-infinities-violation               ^ r fl)
    (make-no-nans-violation                     ^ r fl)
    (&no-infinities                             ^ r fl)
    (no-infinities-violation?                   ^ r fl)
    (&no-nans                                   ^ r fl)
    (no-nans-violation?                         ^ r fl)
    ;;;
    (bytevector->sint-list                      ^ r bv)
    (bytevector->u8-list                        ^ r bv)
    (bytevector->uint-list                      ^ r bv)
    (bytevector-copy                            ^ r bv)
    (bytevector-copy!                           ^ r bv)
    (bytevector-fill!                           ^ r bv)
    (bytevector-ieee-double-native-ref          ^ r bv)
    (bytevector-ieee-double-native-set!         ^ r bv)
    (bytevector-ieee-double-ref                 ^ r bv)
    (bytevector-ieee-double-set!                ^ r bv)
    (bytevector-ieee-single-native-ref          ^ r bv)
    (bytevector-ieee-single-native-set!         ^ r bv)
    (bytevector-ieee-single-ref                 ^ r bv)
    (bytevector-ieee-single-set!                ^ r bv)
    (bytevector-length                          ^ r bv)
    (bytevector-s16-native-ref                  ^ r bv)
    (bytevector-s16-native-set!                 ^ r bv)
    (bytevector-s16-ref                         ^ r bv)
    (bytevector-s16-set!                        ^ r bv)
    (bytevector-s32-native-ref                  ^ r bv)
    (bytevector-s32-native-set!                 ^ r bv)
    (bytevector-s32-ref                         ^ r bv)
    (bytevector-s32-set!                        ^ r bv)
    (bytevector-s64-native-ref                  ^ r bv)
    (bytevector-s64-native-set!                 ^ r bv)
    (bytevector-s64-ref                         ^ r bv)
    (bytevector-s64-set!                        ^ r bv)
    (bytevector-s8-ref                          ^ r bv)
    (bytevector-s8-set!                         ^ r bv)
    (bytevector-sint-ref                        ^ r bv)
    (bytevector-sint-set!                       ^ r bv)
    (bytevector-u16-native-ref                  ^ r bv)
    (bytevector-u16-native-set!                 ^ r bv)
    (bytevector-u16-ref                         ^ r bv)
    (bytevector-u16-set!                        ^ r bv)
    (bytevector-u32-native-ref                  ^ r bv)
    (bytevector-u32-native-set!                 ^ r bv)
    (bytevector-u32-ref                         ^ r bv)
    (bytevector-u32-set!                        ^ r bv)
    (bytevector-u64-native-ref                  ^ r bv)
    (bytevector-u64-native-set!                 ^ r bv)
    (bytevector-u64-ref                         ^ r bv)
    (bytevector-u64-set!                        ^ r bv)
    (bytevector-u8-ref                          ^ r bv)
    (bytevector-u8-set!                         ^ r bv)
    (bytevector-uint-ref                        ^ r bv)
    (bytevector-uint-set!                       ^ r bv)
    (bytevector=?                               ^ r bv)
    (bytevector?                                ^ r bv)
    (endianness                                 ^ r bv)
    (native-endianness                          ^ r bv)
    (sint-list->bytevector                      ^ r bv)
    (string->utf16                              ^ r bv)
    (string->utf32                              ^ r bv)
    (string->utf8                               ^ r bv)
    (u8-list->bytevector                        ^ r bv)
    (uint-list->bytevector                      ^ r bv)
    (utf8->string                               ^ r bv)
    (utf16->string                              ^ r bv)
    (utf32->string                              ^ r bv)
    ;;;
    (condition?                                 ^ r co)
    (&assertion                                 ^ r co)
    (assertion-violation?                       ^ r co)
    (&condition                                 ^ r co)
    (condition                                  ^ r co)
    (condition-accessor                         ^ r co)
    (condition-irritants                        ^ r co)
    (condition-message                          ^ r co)
    (condition-predicate                        ^ r co)
    (condition-who                              ^ r co)
    (define-condition-type                      ^ r co)
    (&error                                     ^ r co)
    (error?                                     ^ r co)
    (&implementation-restriction                ^ r co)
    (implementation-restriction-violation?      ^ r co)
    (&irritants                                 ^ r co)
    (irritants-condition?                       ^ r co)
    (&lexical                                   ^ r co)
    (lexical-violation?                         ^ r co)
    (make-assertion-violation                   ^ r co)
    (make-error                                 ^ r co)
    (make-implementation-restriction-violation  ^ r co)
    (make-irritants-condition                   ^ r co)
    (make-lexical-violation                     ^ r co)
    (make-message-condition                     ^ r co)
    (make-non-continuable-violation             ^ r co)
    (make-serious-condition                     ^ r co)
    (make-syntax-violation                      ^ r co)
    (make-undefined-violation                   ^ r co)
    (make-violation                             ^ r co)
    (make-warning                               ^ r co)
    (make-who-condition                         ^ r co)
    (&message                                   ^ r co)
    (message-condition?                         ^ r co)
    (&non-continuable                           ^ r co)
    (non-continuable-violation?                 ^ r co)
    (&serious                                   ^ r co)
    (serious-condition?                         ^ r co)
    (simple-conditions                          ^ r co)
    (&syntax                                    ^ r co)
    (syntax-violation-form                      ^ r co)
    (syntax-violation-subform                   ^ r co)
    (syntax-violation?                          ^ r co)
    (&undefined                                 ^ r co)
    (undefined-violation?                       ^ r co)
    (&violation                                 ^ r co)
    (violation?                                 ^ r co)
    (&warning                                   ^ r co)
    (warning?                                   ^ r co)
    (&who                                       ^ r co)
    (who-condition?                             ^ r co)
    ;;;
    (case-lambda                                ^ r ct)
    (do                                         ^ r ct se ne)
    (unless                                     ^ r ct)
    (when                                       ^ r ct)
    ;;;
    (define-enumeration                         ^ r en)
    (enum-set->list                             ^ r en)
    (enum-set-complement                        ^ r en)
    (enum-set-constructor                       ^ r en)
    (enum-set-difference                        ^ r en)
    (enum-set-indexer                           ^ r en)
    (enum-set-intersection                      ^ r en)
    (enum-set-member?                           ^ r en)
    (enum-set-projection                        ^ r en)
    (enum-set-subset?                           ^ r en)
    (enum-set-union                             ^ r en)
    (enum-set-universe                          ^ r en)
    (enum-set=?                                 ^ r en)
    (make-enumeration                           ^ r en)
    ;;;
    (environment                                ^ ev)
    (eval                                       ^ ev se)
    ;;;
    (raise                                      ^ r ex)
    (raise-continuable                          ^ r ex)
    (with-exception-handler                     ^ r ex)
    (guard                                      ^ r ex)
    ;;;
    (binary-port?                               ^ r ip)
    (buffer-mode                                ^ r ip)
    (buffer-mode?                               ^ r ip)
    (bytevector->string                         ^ r ip)
    (call-with-bytevector-output-port           ^ r ip)
    (call-with-port                             ^ r ip)
    (call-with-string-output-port               ^ r ip)
    ;;;
    (assoc                                      ^ r ls se)
    (assp                                       ^ r ls)
    (assq                                       ^ r ls se)
    (assv                                       ^ r ls se)
    (cons*                                      ^ r ls)
    (filter                                     ^ r ls)
    (find                                       ^ r ls)
    (fold-left                                  ^ r ls)
    (fold-right                                 ^ r ls)
    (for-all                                    ^ r ls)
    (exists                                     ^ r ls)
    (member                                     ^ r ls se)
    (memp                                       ^ r ls)
    (memq                                       ^ r ls se)
    (memv                                       ^ r ls se)
    (partition                                  ^ r ls)
    (remq                                       ^ r ls)
    (remp                                       ^ r ls)
    (remv                                       ^ r ls)
    (remove                                     ^ r ls)
    ;;;
    (set-car!                                   ^ mp se)
    (set-cdr!                                   ^ mp se)
    ;;;
    (string-set!                                ^ ms se)
    (string-fill!                               ^ ms se)
    ;;;
    (command-line                               ^ r pr)
    (exit                                       ^ r pr)
    ;;;
    (delay                                      ^ r5 se ne)
    (exact->inexact                             ^ r5 se)
    (force                                      ^ r5 se)
    (inexact->exact                             ^ r5 se)
    (modulo                                     ^ r5 se)
    (remainder                                  ^ r5 se)
    (null-environment                           ^ r5 se)
    (quotient                                   ^ r5 se)
    (scheme-report-environment                  ^ r5 se)
    ;;;
    (close-port                                 ^ r ip)
    (eol-style                                  ^ r ip)
    (error-handling-mode                        ^ r ip)
    (file-options                               ^ r ip)
    (flush-output-port                          ^ r ip)
    (get-bytevector-all                         ^ r ip)
    (get-bytevector-n                           ^ r ip)
    (get-bytevector-n!                          ^ r ip)
    (get-bytevector-some                        ^ r ip)
    (get-char                                   ^ r ip)
    (get-datum                                  ^ r ip)
    (get-line                                   ^ r ip)
    (get-string-all                             ^ r ip)
    (get-string-n                               ^ r ip)
    (get-string-n!                              ^ r ip)
    (get-u8                                     ^ r ip)
    (&i/o                                       ^ r ip is fi)
    (&i/o-decoding                              ^ r ip)
    (i/o-decoding-error?                        ^ r ip)
    (&i/o-encoding                              ^ r ip)
    (i/o-encoding-error-char                    ^ r ip)
    (i/o-encoding-error?                        ^ r ip)
    (i/o-error-filename                         ^ r ip is fi)
    (i/o-error-port                             ^ r ip is fi)
    (i/o-error-position                         ^ r ip is fi)
    (i/o-error?                                 ^ r ip is fi)
    (&i/o-file-already-exists                   ^ r ip is fi)
    (i/o-file-already-exists-error?             ^ r ip is fi)
    (&i/o-file-does-not-exist                   ^ r ip is fi)
    (i/o-file-does-not-exist-error?             ^ r ip is fi)
    (&i/o-file-is-read-only                     ^ r ip is fi)
    (i/o-file-is-read-only-error?               ^ r ip is fi)
    (&i/o-file-protection                       ^ r ip is fi)
    (i/o-file-protection-error?                 ^ r ip is fi)
    (&i/o-filename                              ^ r ip is fi)
    (i/o-filename-error?                        ^ r ip is fi)
    (&i/o-invalid-position                      ^ r ip is fi)
    (i/o-invalid-position-error?                ^ r ip is fi)
    (&i/o-port                                  ^ r ip is fi)
    (i/o-port-error?                            ^ r ip is fi)
    (&i/o-read                                  ^ r ip is fi)
    (i/o-read-error?                            ^ r ip is fi)
    (&i/o-write                                 ^ r ip is fi)
    (i/o-write-error?                           ^ r ip is fi)
    (lookahead-char                             ^ r ip)
    (lookahead-u8                               ^ r ip)
    (make-bytevector                            ^ r bv)
    (make-custom-binary-input-port              ^ r ip)
    (make-custom-binary-input/output-port       ^ r ip)
    (make-custom-binary-output-port             ^ r ip)
    (make-custom-textual-input-port             ^ r ip)
    (make-custom-textual-input/output-port      ^ r ip)
    (make-custom-textual-output-port            ^ r ip)
    (make-i/o-decoding-error                    ^ r ip)
    (make-i/o-encoding-error                    ^ r ip)
    (make-i/o-error                             ^ r ip is fi)
    (make-i/o-file-already-exists-error         ^ r ip is fi)
    (make-i/o-file-does-not-exist-error         ^ r ip is fi)
    (make-i/o-file-is-read-only-error           ^ r ip is fi)
    (make-i/o-file-protection-error             ^ r ip is fi)
    (make-i/o-filename-error                    ^ r ip is fi)
    (make-i/o-invalid-position-error            ^ r ip is fi)
    (make-i/o-port-error                        ^ r ip is fi)
    (make-i/o-read-error                        ^ r ip is fi)
    (make-i/o-write-error                       ^ r ip is fi)
    (latin-1-codec                              ^ r ip)
    (make-transcoder                            ^ r ip)
    (native-eol-style                           ^ r ip)
    (native-transcoder                          ^ r ip)
    (open-bytevector-input-port                 ^ r ip)
    (open-bytevector-output-port                ^ r ip)
    (open-file-input-port                       ^ r ip)
    (open-file-input/output-port                ^ r ip)
    (open-file-output-port                      ^ r ip)
    (open-string-input-port                     ^ r ip)
    (open-string-output-port                    ^ r ip)
    (output-port-buffer-mode                    ^ r ip)
    (port-eof?                                  ^ r ip)
    (port-has-port-position?                    ^ r ip)
    (port-has-set-port-position!?               ^ r ip)
    (port-position                              ^ r ip)
    (port-transcoder                            ^ r ip)
    (port?                                      ^ r ip)
    (put-bytevector                             ^ r ip)
    (put-char                                   ^ r ip)
    (put-datum                                  ^ r ip)
    (put-string                                 ^ r ip)
    (put-u8                                     ^ r ip)
    (set-port-position!                         ^ r ip)
    (standard-error-port                        ^ r ip)
    (standard-input-port                        ^ r ip)
    (standard-output-port                       ^ r ip)
    (string->bytevector                         ^ r ip)
    (textual-port?                              ^ r ip)
    (transcoded-port                            ^ r ip)
    (transcoder-codec                           ^ r ip)
    (transcoder-eol-style                       ^ r ip)
    (transcoder-error-handling-mode             ^ r ip)
    (utf-16-codec                               ^ r ip)
    (utf-8-codec                                ^ r ip)
    ;;;
    (input-port?                                ^ r is ip se)
    (output-port?                               ^ r is ip se)
    (current-input-port                         ^ r ip is se)
    (current-output-port                        ^ r ip is se)
    (current-error-port                         ^ r ip is)
    (eof-object                                 ^ r ip is)
    (eof-object?                                ^ r ip is se)
    (close-input-port                           ^ r is se)
    (close-output-port                          ^ r is se)
    (display                                    ^ r is se)
    (newline                                    ^ r is se)
    (open-input-file                            ^ r is se)
    (open-output-file                           ^ r is se)
    (peek-char                                  ^ r is se)
    (read                                       ^ r is se)
    (read-char                                  ^ r is se)
    (with-input-from-file                       ^ r is se)
    (with-output-to-file                        ^ r is se)
    (write                                      ^ r is se)
    (write-char                                 ^ r is se)
    (call-with-input-file                       ^ r is se)
    (call-with-output-file                      ^ r is se)
    ;;;
    (hashtable-clear!                           ^ r ht)
    (hashtable-contains?                        ^ r ht)
    (hashtable-copy                             ^ r ht)
    (hashtable-delete!                          ^ r ht)
    (hashtable-entries                          ^ r ht)
    (hashtable-keys                             ^ r ht)
    (hashtable-mutable?                         ^ r ht)
    (hashtable-ref                              ^ r ht)
    (hashtable-set!                             ^ r ht)
    (hashtable-size                             ^ r ht)
    (hashtable-update!                          ^ r ht)
    (hashtable?                                 ^ r ht)
    (make-eq-hashtable                          ^ r ht)
    (make-eqv-hashtable                         ^ r ht)
    (hashtable-hash-function                    ^ r ht)
    (make-hashtable                             ^ r ht)
    (hashtable-equivalence-function             ^ r ht)
    (equal-hash                                 ^ r ht)
    (string-hash                                ^ r ht)
    (string-ci-hash                             ^ r ht)
    (symbol-hash                                ^ r ht)
    ;;;
    (list-sort                                  ^ r sr)
    (vector-sort                                ^ r sr)
    (vector-sort!                               ^ r sr)
    ;;;
    (file-exists?                               ^ r fi)
    (delete-file                                ^ r fi)
    ;;;
    (define-record-type                         ^ r rs)
    (fields                                     ^ r rs)
    (immutable                                  ^ r rs)
    (mutable                                    ^ r rs)
    (opaque                                     ^ r rs)
    (parent                                     ^ r rs)
    (parent-rtd                                 ^ r rs)
    (protocol                                   ^ r rs)
    (record-constructor-descriptor              ^ r rs)
    (record-type-descriptor                     ^ r rs)
    (sealed                                     ^ r rs)
    (nongenerative                              ^ r rs)
    ;;;
    (record-field-mutable?                      ^ r ri)
    (record-rtd                                 ^ r ri)
    (record-type-field-names                    ^ r ri)
    (record-type-generative?                    ^ r ri)
    (record-type-name                           ^ r ri)
    (record-type-opaque?                        ^ r ri)
    (record-type-parent                         ^ r ri)
    (record-type-sealed?                        ^ r ri)
    (record-type-uid                            ^ r ri)
    (record?                                    ^ r ri)
    ;;;
    (make-record-constructor-descriptor         ^ r rp)
    (make-record-type-descriptor                ^ r rp)
    (record-accessor                            ^ r rp)
    (record-constructor                         ^ r rp)
    (record-mutator                             ^ r rp)
    (record-predicate                           ^ r rp)
    (record-type-descriptor?                    ^ r rp)
    ;;;
    (syntax-violation                           ^ r sc)
    (bound-identifier=?                         ^ r sc)
    (datum->syntax                              ^ r sc)
    (syntax                                     ^ r sc)
    (syntax->datum                              ^ r sc)
    (syntax-case                                ^ r sc)
    (unsyntax                                   ^ r sc)
    (unsyntax-splicing                          ^ r sc)
    (quasisyntax                                ^ r sc)
    (with-syntax                                ^ r sc)
    (free-identifier=?                          ^ r sc)
    (generate-temporaries                       ^ r sc)
    (identifier?                                ^ r sc)
    (make-variable-transformer                  ^ r sc)
    ;;;
    (char-alphabetic?                           ^ r uc se)
    (char-ci<=?                                 ^ r uc se)
    (char-ci<?                                  ^ r uc se)
    (char-ci=?                                  ^ r uc se)
    (char-ci>=?                                 ^ r uc se)
    (char-ci>?                                  ^ r uc se)
    (char-downcase                              ^ r uc se)
    (char-foldcase                              ^ r uc)
    (char-titlecase                             ^ r uc)
    (char-upcase                                ^ r uc se)
    (char-general-category                      ^ r uc)
    (char-lower-case?                           ^ r uc se)
    (char-numeric?                              ^ r uc se)
    (char-title-case?                           ^ r uc)
    (char-upper-case?                           ^ r uc se)
    (char-whitespace?                           ^ r uc se)
    (string-ci<=?                               ^ r uc se)
    (string-ci<?                                ^ r uc se)
    (string-ci=?                                ^ r uc se)
    (string-ci>=?                               ^ r uc se)
    (string-ci>?                                ^ r uc se)
    (string-downcase                            ^ r uc)
    (string-foldcase                            ^ r uc)
    (string-normalize-nfc                       ^ r uc)
    (string-normalize-nfd                       ^ r uc)
    (string-normalize-nfkc                      ^ r uc)
    (string-normalize-nfkd                      ^ r uc)
    (string-titlecase                           ^ r uc)
    (string-upcase                              ^ r uc)
    ;;;
    ; (char-ready?                                )
    (interaction-environment                    ^)
    (load                                       ^)
    ;;;
    (void                     $boot ^)
    (gensym                   $boot ^)
    (symbol-value             $boot)
    (set-symbol-value!        $boot)
    (eval-core                $boot)
    (pretty-print             $boot ^)
    (module                   cm ^)
    (syntax-dispatch ) ; only goes to $all
    (syntax-error    ) ; only goes to $all
    (assertion-error )
    (undefined-variable)
    (make-file-options)
    (ellipsis-map) ;for psyntax
    (make-promise)
    ;;; Enabled by if-wants-qq in (psyntax config)
    (qq)
    (qcons)
    (qlist)
    (qappend)
    (qvector)
    (qlist->vector)

    (&condition-rtd)
    (&condition-rcd)
    (&message-rtd)
    (&message-rcd)
    (&warning-rtd)
    (&warning-rcd)
    (&serious-rtd)
    (&serious-rcd)
    (&error-rtd)
    (&error-rcd)
    (&violation-rtd)
    (&violation-rcd)
    (&assertion-rtd)
    (&assertion-rcd)
    (&irritants-rtd)
    (&irritants-rcd)
    (&who-rtd)
    (&who-rcd)
    (&non-continuable-rtd)
    (&non-continuable-rcd)
    (&implementation-restriction-rtd)
    (&implementation-restriction-rcd)
    (&lexical-rtd)
    (&lexical-rcd)
    (&syntax-rtd)
    (&syntax-rcd)
    (&undefined-rtd)
    (&undefined-rcd)
    (&i/o-rtd)
    (&i/o-rcd)
    (&i/o-read-rtd)
    (&i/o-read-rcd)
    (&i/o-write-rtd)
    (&i/o-write-rcd)
    (&i/o-invalid-position-rtd)
    (&i/o-invalid-position-rcd)
    (&i/o-filename-rtd)
    (&i/o-filename-rcd)
    (&i/o-file-protection-rtd)
    (&i/o-file-protection-rcd)
    (&i/o-file-is-read-only-rtd)
    (&i/o-file-is-read-only-rcd)
    (&i/o-file-already-exists-rtd)
    (&i/o-file-already-exists-rcd)
    (&i/o-file-does-not-exist-rtd)
    (&i/o-file-does-not-exist-rcd)
    (&i/o-port-rtd)
    (&i/o-port-rcd)
    (&i/o-decoding-rtd)
    (&i/o-decoding-rcd)
    (&i/o-encoding-rtd)
    (&i/o-encoding-rcd)
    (&no-infinities-rtd)
    (&no-infinities-rcd)
    (&no-nans-rtd)
    (&no-nans-rcd)

    ;;; SRFI 98
    (get-environment-variables   ^ s98 srfi98)
    (get-environment-variable    ^ s98 srfi98)

    ;;; Loko
    (library                   ^)
    (define-library            ^)
    (export                    ^)
    (import                    ^)
    (include                   ^)
    (include/resolve           ^)
    (installed-libraries       ^)
    (uninstall-library         ^)
    (library-directories       ^)
    (library-extensions        ^)
    (library-available?        ^)
    (environment-symbols       ^)
    (time                      ^)
    (time-it                   ^)
    (time-it*                  ^)
    (cp0-size-limit            ^)
    (cp0-effort-limit          ^)
    (expand                    ^)
    (expand/optimize           ^)
    (disassemble               ^)
    (machine-type              ^)
    (compile-program           ^)
    (open-output-string        ^)       ;for SRFI 6
    (get-output-string         ^)       ;for SRFI 6
    (port-file-descriptor      ^)       ;for SRFI-170
    (port-file-descriptor-set! ^)       ;for SRFI-170
    (port-buffer-mode-set!     ^)       ;for SRFI-170
    (parameterize              ^)       ;Chez-style (not SRFI-39)
    (make-parameter            ^)       ;Chez-style (not SRFI-39)
    (record-writer             ^)       ;Chez-style record writers
    (loko-version              ^)       ;Loko version number, SemVer
    (putenv                    ^)
    (collections               ^)       ;Chez compatible
    (load-program              ^)       ;Chez compatible (one argument)
    (case-sensitive            ^)       ;almost Chez compatible (should be fixed)
    (print-dialects            ^)

    ;; Procedures that cp0 can emit calls to
    (bitwise-lsr)
    (symbol-ref)

    ;; The (loko system r7rs) library.
    ;; Users should use these via (scheme base) or (scheme write).
    (features                  r7)
    (emergency-exit            r7)
    (input-port-open?          r7)
    (output-port-open?         r7)
    (write-shared              r7)
    (write-simple              r7)
    (current-output-port*      r7)
    (current-error-port*       r7)
    (current-input-port*       r7)
    (include/r7rs              r7)
    (u8-ready?                 r7)
    (char-ready?               r7)

    ;; The (loko compiler compat) library
    (gensym?                  $compat)
    (gensym->unique-string    $compat)
    (gensym-prefix            $compat)

    ;; The (loko system time) library
    (time?                    time)
    (make-time                time)
    (time-type                time)
    (time-second              time)
    (time-nanosecond          time)
    (set-time-type!           time)
    (set-time-nanosecond!     time)
    (set-time-second!         time)
    (current-ticks            time)
    (current-second           time)
    (current-time/process     time)
    (current-time/utc         time)
    (current-time/monotonic   time)
    (set-current-time/utc     time)

    ;; The (loko system unsafe) library
    (get-i/o-u8    lsu) (get-i/o-u16    lsu) (get-i/o-u32    lsu)
    (put-i/o-u8    lsu) (put-i/o-u16    lsu) (put-i/o-u32    lsu)
    (get-i/o-u8-n! lsu) (get-i/o-u16-n! lsu) (get-i/o-u32-n! lsu)
    (get-mem-u8    lsu) (get-mem-u16    lsu) (get-mem-u32    lsu) (get-mem-s61 lsu)
    (put-mem-u8    lsu) (put-mem-u16    lsu) (put-mem-u32    lsu) (put-mem-s61 lsu)
    (syscall       lsu)
    (bytevector-address lsu)

    ;; The (loko system unsafe cache) library
    (cache-line-flush  cache)
    (cache-line-size   cache)
    (memory-fence      cache)
    (load-fence        cache)
    (store-fence       cache)

    ;; The (loko system fibers) library
    (run-fibers               fibers)
    (spawn-fiber              fibers)
    (wrap-operation           fibers)
    (choice-operation         fibers)
    (perform-operation        fibers)
    (make-channel             fibers)
    (channel?                 fibers)
    (put-operation            fibers)
    (get-operation            fibers)
    (put-message              fibers)
    (get-message              fibers)
    (sleep-operation          fibers)
    (timer-operation          fibers)
    (sleep                    fibers)
    (wait-for-readable        fibers)
    (wait-for-writable        fibers)
    (make-cvar                fibers)
    (cvar?                    fibers)
    (signal-cvar!             fibers)
    (wait-operation           fibers)
    (wait                     fibers)
    (yield-current-task       fibers)
    (exit-current-task        fibers)

    ;; The (loko system file-system) library (experimental!)
    (set-file-mode            fs)
    (directory-files          fs)

    ;; (loko system random)
    (get-random-bytevector-n! random)
    (get-random-u8            random)

    ;; (loko system logging) and (srfi :215 logging)
    (send-log                 log srfi215 s215)
    (current-log-fields       log srfi215 s215)
    (current-log-callback     log srfi215 s215)
    (severity->symbol         log)
    (EMERGENCY                log srfi215 s215)
    (ALERT                    log srfi215 s215)
    (CRITICAL                 log srfi215 s215)
    (ERROR                    log srfi215 s215)
    (WARNING                  log srfi215 s215)
    (NOTICE                   log srfi215 s215)
    (INFO                     log srfi215 s215)
    (DEBUG                    log srfi215 s215)

    (cpuid                    $x86)
    (rdtsc                    $x86)
    (rdrand                   $x86)
    (rdseed                   $x86)

    ($mmap                    $host)
    (valgrind                 $host)
    (nanosleep                $host)
    (stack-trace              $host)
    (add-fdes-finalizer!      $host)
    (call-fd-finalizer        $host)
    (install-vfs              $host)

    ($process-start           $host)
    ($make-ustate             $host)
    ($free-ustate             $host)
    (make-usermode-page-table $host)
    (page-table-map!          $host)
    (page-table-lookup        $host)
    (page-table-free!         $host)
    (new-usermode-process     $host)
    (wait-process-operation   $host)
    (process-resume           $host)
    (process-exit             $host)

    (dma-allocate             $host)
    (dma-free                 $host)
    (enable-irq               $host)
    (wait-irq-operation       $host)
    (enable-signal            $host)
    (acknowledge-signal       $host)
    (wait-signal-operation    $host)

    ;; The (loko system $primitives) library
    ($bootstrap-symbols       $p)
    ($bootstrap-rtds          $p)
    ($make-bytevector         $p)
    ($make-vector             $p)
    ($make-string             $p)
    ($cons                    $p)
    ($immsym?                 $p)
    ($immsym->fixnum          $p)
    ($fixnum->immsym          $p)
    ($fx+/false               $p)
    ($fx-/false               $p)
    ($fx*/false               $p)
    ($fxquo+rem               $p)
    ($fxasl/false             $p)
    ($fxasr/false             $p)
    ($fxlength                $p)
    ($fxfirst-bit-set         $p)
    ($box?                    $p)
    ($make-box                $p)
    ($box-type                $p)
    ($box-type-set!           $p)
    ($box-ref                 $p)
    ($box-set!                $p)
    ($make-box-header         $p)
    ($box-header?             $p)
    ($box-header-length       $p)
    ($box-header-type-eq?     $p)
    ($box-header-refs?        $p)
    ($box-header-value        $p)
    ($procedure-info          $p)
    ($procedure-info-set!     $p)
    ($procedure-length        $p)
    ($procedure-ref           $p)
    ($processor-data-set!     $p)
    ($processor-data-ref      $p)
    ($copy-stack              $p)
    ($restore-stack           $p)
    ($switch-stack            $p)
    ($values                  $p)
    ($void->fixnum            $p)
    ($void?                   $p)
    ($valgrind                $p)
    ($debug-display           $p)
    ($debug-put-u8            $p)
    ($boot-loader-data        $p)
    ($boot-loader-type        $p)
    ($linker-address          $p)     ;link-time access to linker symbols
    ($heap-remaining          $p)     ;for the time-it procedure
    ($stack-pointer           $p)     ;for stack traces
    ($object->fixnum          $p)
    ;; ($current-closure         $p)
    ($syscall/carry!          $p)     ;FIXME: should use multiple values instead
    ($disable-interrupts      $p)
    ($enable-interrupts       $p)

    ))

(define (verify-map)
  (define (f x)
    (for-each
      (lambda (x)
        (unless (assq x library-legend)
          (error 'verify "~s is not in the libraries list" x)))
      (cdr x)))
  (for-each f identifier->library-map))

(define (make-collection)
  (let ((set '()))
    (case-lambda
      (() set)
      ((x) (set! set (cons x set))))))

(define (make-system-data subst env)
  (define who 'make-system-data)
  (let ((export-subst    (make-collection))
        (export-env      (make-collection))
        (export-primlocs (make-collection)))
    (for-each
      (lambda (x)
        (let ((name (car x)) (binding (cadr x)))
          (let ((label (gensym)))
            (export-subst (cons name label))
            (export-env   (cons label binding)))))
      psyntax-system-macros)
    (for-each
      (lambda (x)
        (cond
          ((macro-identifier x) (values))
          ((assq x (export-subst))
           (error who "ambiguous export of ~s" x))
          ((assq x subst) =>
           ;; primitive defined (exported) within the compiled libraries
           (lambda (p)
             (let ((label (cdr p)))
               (cond
                 ((assq label env) =>
                  (lambda (p)
                    (let ((binding (cdr p)))
                      (case (car binding)
                        ((global)
                         (export-subst (cons x label))
                         (export-env   (cons label (cons 'core-prim x)))
                         (export-primlocs (cons x (cdr binding))))
                        (else
                         (error #f "invalid binding ~s for ~s" p x))))))
                 (else
                  (error #f "cannot find binding for ~s" x))))))
          (else
           ;; core primitive with no backing definition, assumed to
           ;; be defined in other strata of the system
           (let ((label (gensym)))
             (export-subst (cons x label))
             (export-env (cons label (cons 'core-prim x)))))))
      (map car identifier->library-map))
    (values (export-subst) (export-env) (export-primlocs))))

(define (get-export-subset key subst)
  (let f ((ls subst))
    (cond
      ((null? ls) '())
      (else
       (let ((x (car ls)))
         (let ((name (car x)))
           (cond
             ((assq name identifier->library-map)
              =>
              (lambda (q)
                (cond
                  ((memq key (cdr q))
                   (cons x (f (cdr ls))))
                  (else (f (cdr ls))))))
             (else
              ;; not going to any library?
              (f (cdr ls))))))))))

(define (build-system-library export-subst export-env primlocs use-hashtable)
  (define (build-library legend-entry)
    (let ((key (car legend-entry))
          (name (cadr legend-entry))
          (visible? (caddr legend-entry)))
      (let ((id          (gensym))
            (name        name)
            (version     (if (eq? (car name) 'rnrs) '(6) '()))
            (import-libs '())
            (visit-libs  '())
            (invoke-libs '()))
        (let-values (((subst env)
                      (if (equal? name '(psyntax system $all))
                          (values export-subst export-env)
                          (values
                            (get-export-subset key export-subst)
                            '()))))
          `(install-library
             ',id ',name ',version ',import-libs ',visit-libs ',invoke-libs
             ',subst ',env values values '#f '#f '#f '() ',visible? '#f)))))
  (let ((code `(library (loko primlocs)
                  (export) ;;; must be empty
                  (import
                    (only (psyntax library-manager)
                          install-library)
                    (only (psyntax internal)
                          current-primitive-locations)
                    (rnrs lists)
                    (rnrs hashtables)
                    (rnrs base))
                  (current-primitive-locations
                   (lambda (x)
                     ,(if use-hashtable
                          (let ((ht (make-eq-hashtable)))
                            ;; Unless the hashtable representation has
                            ;; changed (which then requires a
                            ;; bootstrap build), a serialized
                            ;; hashtable can be used at runtime.
                            (for-each (lambda (primloc)
                                        (hashtable-set! ht (car primloc) (cdr primloc)))
                                      primlocs)
                            `(hashtable-ref ',ht x #f))
                          `(cond
                             ((assq x ',primlocs) => cdr)
                             (else #f)))))
                  ,@(map build-library library-legend))))
    (let-values (((name code empty-subst empty-env)
                  (boot-library-expand code)))
       (values name code))))

(define (make-init-code)
  (values '() '() '() '()))

(define (load fn proc)
  (let ((fn^ (strip-akku-prefix fn)))
    (with-input-from-file fn
      (lambda ()
        (let f ()
          (let ((x (read-annotated (current-input-port) fn^)))
            (unless (eof-object? x)
              (proc x)
              (f))))))))

(define (read-code fn)
  (let ((fn^ (strip-akku-prefix fn)))
    (call-with-input-file fn
      (lambda (p)
        (let lp ((codes '()))
          (let ((datum (read-annotated p fn^)))
            (if (eof-object? datum)
                (reverse codes)
                (lp (cons datum codes)))))))))

;;; remove all re-exported identifiers (those with labels in
;;; subst but not binding in env).
(define (prune-subst subst env)
  (cond
    ((null? subst) '())
    ((not (assq (cdar subst) env)) (prune-subst (cdr subst) env))
    (else (cons (car subst) (prune-subst (cdr subst) env)))))

(define (expand-all files top-level-file use-primlocs freestanding verbose)
  (define ls '())
  (let-values (((name* code* subst env) (make-init-code)))
    (for-each
     (lambda (file)
       (when verbose
         (display " ")
         (display file)
         (newline))
       (load file
             (lambda (x)
               (let-values (((name code export-subst export-env)
                             (boot-library-expand x)))
                 (set! ls (cons name ls))
                 (set! name* (cons name name*))
                 (set! code* (cons code code*))
                 (set! subst (append export-subst subst))
                 (set! env (append export-env env))))))
     files)
    (letrec ((expand-top-level
              (lambda (name top-level-code)
                (let-values ([(req* exp _macro* _export-subst _export-env)
                              (top-level-expander top-level-code)])
                  (define (serialize lib)
                    (unless (member (library-name lib) ls)
                      (set! ls (cons (library-name lib) ls))
                      (for-each serialize (library-invoke-dependencies lib))
                      (set! name* (cons (library-name lib) name*))
                      (set! code* (cons (library-invoke-code lib) code*))))
                  (for-each serialize req*)
                  (set! name* (cons name name*))
                  (set! code* (cons exp code*))))))
      (cond (top-level-file
             (when verbose
               (display " ")
               (display top-level-file)
               (newline))
             (expand-top-level '(*main*) (read-code top-level-file)))
            (else
             (expand-top-level '(*main*) '((import)))))
      (unless freestanding
        (expand-top-level '(*exit*)
                          '((import (only (rnrs) exit))
                            (exit 0)))))
    (let-values (((export-subst export-env export-locs)
                  (make-system-data (prune-subst subst env) env)))
      (if use-primlocs
          (let-values (((name code)
                        (build-system-library export-subst export-env export-locs
                                              (eq? use-primlocs 'hashtable))))
            ;; Insert the primloc library just before (*main*)
            (values
              (reverse (cons* (car name*) (cadr name*) name (cddr name*)))
              (reverse (cons* (car code*) (cadr code*) code (cddr code*)))
              export-locs))
          (values (reverse name*) (reverse code*) export-locs)))))

(define bootstrap-collection
  (let ((ls '()))
    (case-lambda
      (() ls)
      ((x)
       (unless (memq x ls)
         (set! ls (cons x ls)))))))

(define (copy-collection collection)
  (let ((ls (collection)))
    (case-lambda
      (() ls)
      ((x)
       (unless (memq x ls)
         (set! ls (cons x ls)))))))

(define initialize
  (let ((done? #f))
    (lambda ()
      (unless done?
        (set! done? #t)
        (verify-map)
        (let ((all-names (map car identifier->library-map))
              (all-labels (map (lambda (x) (gensym)) identifier->library-map))
              (all-bindings (map (lambda (x)
                                   (cond
                                     ((macro-identifier x) => cadr)
                                     (else `(core-prim . ,x))))
                                 (map car identifier->library-map))))
          (let ((export-subst (map cons all-names all-labels))
                (export-env (map cons all-labels all-bindings)))
            (define (build-library legend-entry)
              (let ((key (car legend-entry))
                    (name (cadr legend-entry))
                    (visible? (caddr legend-entry))
                    (required? (cadddr legend-entry)))
                (when required?
                  (let ((id          (gensym))
                        (name        name)
                        (version     (if (eq? (car name) 'rnrs) '(6) '()))
                        (import-libs '())
                        (visit-libs  '())
                        (invoke-libs '()))
                    (let-values (((subst env)
                                  (if (equal? name '(psyntax system $all))
                                      (values export-subst export-env)
                                      (values
                                        (get-export-subset key export-subst)
                                        '()))))
                      (parameterize ((current-library-collection bootstrap-collection))
                        (install-library
                         id name version import-libs visit-libs invoke-libs
                         subst env values values '#f '#f '#f '() visible? '#f)))))))
            (for-each build-library library-legend)))))))

;; Expand an a list of .sls files followed by an optional .sps file.
;; The .sps file can pull in additional libraries. Returns a list of
;; names, a list of core forms and export locations. Set use-primlocs
;; to true to include the (loko primlocs) library, as required by
;; eval, and set it to 'hashtable to include the table as a serialized
;; hashtable (but don't do that when bootstrapping).
(define (expand-files scheme-library-files scheme-program-file use-primlocs freestanding verbose)
  (initialize)
  (let-values (((name* core* locs)
                (parameterize ((current-library-collection (copy-collection bootstrap-collection)))
                  (expand-all scheme-library-files
                              scheme-program-file
                              use-primlocs freestanding verbose))))
    #;
    (current-primitive-locations
     (lambda (x)
       (cond ((assq x locs) => cdr)
             (else
              (error 'bootstrap "No location for primitive" x)))))
    (values name* core* locs))))
