(module ($char-constituent? $char-subsequent? $char-upper-case?
         $char-lower-case? $char-title-case? $char-alphabetic?
         $char-numeric? $char-whitespace? $char-cased?
         $char-case-ignorable? $char-category $wb-aletter?
         $wb-numeric? $wb-katakana? $wb-extend? $wb-format?
         $wb-midnum? $wb-midletter? $wb-midnumlet? $wb-extendnumlet?
         $char-combining-class $char-dump $wb-hebrew-letter?
         $wb-single-quote? $wb-double-quote? $wb-regional-indicator?
         $wb-zwj? $wb-wsegspace?)
  (define category-mask 31)
  (define unicode-category-table
    '#(#(#(25600 25600 25600 25600 25600 25600 25600 25600 25600 26112
           386560 419328 419328 353792 25600 25600 25600 25600 25600
           25600 25600 25600 25600 25600 25600 25600 25600 25600 25600
           25600 25600 25600 612864 17408 443392 17408 19456 17408
           17408 476162 13312 14336 17408 18432 214016 12288 279554
           17408 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 246786 214016 18432 18432 18432 17408)
         #(17408 32913 32913 32913 32913 32913 32913 32913 32913 32913
           32913 32913 32913 32913 32913 32913 32913 32913 32913 32913
           32913 32913 32913 32913 32913 32913 32913 13312 17408 14336
           20482 306176 20482 33953 33953 33953 33953 33953 33953 33953
           33953 33953 33953 33953 33953 33953 33953 33953 33953 33953
           33953 33953 33953 33953 33953 33953 33953 33953 33953 13312
           18432 14336 18432 25600)
         #(25600 25600 25600 25600 25600 419328 25600 25600 25600 25600
           25600 25600 25600 25600 25600 25600 25600 25600 25600 25600
           25600 25600 25600 25600 25600 25600 25600 25600 25600 25600
           25600 25600 23040 17412 19460 19460 19460 19460 21508 17412
           20486 21508 37028 15360 18436 190466 21508 20486 21508 18436
           10500 10500 20486 33957 17412 246790 20486 10500 37028 16384
           10500 10500 10500 17412)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 18436 32917 32917 32917 32917 32917 32917
           32917 33956 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 18436 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 33956 32917 33957 32917
           33957 32917 33957 32917)
         #(33957 32917 33957 32917 33957 32917 33957 32917 33957 33956
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 32917 33957 32917
           33957 32917 33957 33957)
         #(33957 32917 32917 33957 32917 33957 32917 32917 33957 32917
           32917 32917 33957 33956 32917 32917 32917 32917 33957 32917
           32917 33957 32917 32917 32917 33957 33957 33956 32917 32917
           33957 32917 32917 33957 32917 33957 32917 33957 32917 32917
           33957 32917 33956 33956 32917 33957 32917 32917 33957 32917
           32917 32917 33957 32917 33957 32917 32917 33957 33956 36996
           32917 33957 33956 33957)
         #(36996 36996 36996 36996 32917 35013 33957 32917 35013 33957
           32917 35013 33957 32917 33957 32917 33957 32917 33957 32917
           33957 32917 33957 32917 33957 32917 33957 32917 33957 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 33956 32917
           35013 33957 32917 33957 32917 32917 32917 33957 32917 33957
           32917 33957 32917 33957)
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33956 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 33956 33956 33956 33956 33956 33956 32917 32917
           33957 32917 32917 33957)
         #(33957 32917 33957 32917 32917 32917 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 33957 33957 33957 33957
           33957 33956 33957 33957 33956 33957 33956 33957 33957 33956
           33956 33956 33957 33957 33956 33957 33956 33957 33957 33956
           33957 33957 33957 33957 33957 33956 33956 33957 33956 33957
           33957 33956 33956 33957 33956 33956 33956 33956 33956 33956
           33956 33957 33956 33956)
         #(33957 33956 33957 33957 33956 33956 33956 33957 33957 33957
           33957 33957 33957 33956 33956 33956 33956 33956 33957 33956
           36996 33956 33956 33956 33956 33956 33956 33956 33956 33957
           33957 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 36006 36006
           36006 36006 36006 36006 36006 36006 36006 35974 35974 35974
           35974 35974 35974 35974)
         #(36006 36006 53254 53254 53254 53254 35974 35974 35974 35974
           35974 35974 35974 35974 35974 35974 35974 35974 53254 53254
           53254 53254 53254 53254 20486 20486 20486 20486 20486 20486
           53254 53254 36006 36006 36006 36006 36006 53254 53254 53254
           53254 53254 53254 53254 35974 53254 35974 53254 53254 53254
           53254 53254 53254 53254 53254 53254 53254 53254 53254 53254
           53254 53254 53254 53254)
         #(241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 243405830 230822918 230822918
           230822918 230822918 243405830 226628614 230822918 230822918
           230822918 230822918 230822918 211948550 211948550 230822918
           230822918 230822918 230822918 211948550 211948550 230822918
           230822918 230822918 230822918 230822918 230822918 230822918
           230822918 230822918 230822918 230822918 1184774 1184774
           1184774 1184774 1184774 230822918 230822918 230822918
           230822918 241308678 241308678 241308678)
         #(241308678 241308678 241308678 241308678 241308678 251794599
           241308678 230822918 230822918 230822918 241308678 241308678
           241308678 230822918 230822918 136198 241308678 241308678
           241308678 230822918 230822918 230822918 230822918 241308678
           243405830 230822918 230822918 241308678 244454406 245502982
           245502982 244454406 245502982 245502982 244454406 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           32917 33957 32917 33957 35974 20486 32917 33957 29696 29696
           36006 33957 33957 33957 214020 32917)
         #(29696 29696 29696 29696 20486 20486 32917 246790 32917 32917
           32917 29696 32917 29696 32917 32917 33956 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 29696 32917 32917 32917 32917 32917
           32917 32917 32917 32917 33957 33957 33957 33957 33956 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 32917 33957 33957 32916 32916
           32916 33957 33957 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 33957 33957
           33957 33957 32917 33957 18436 32917 33957 32917 32917 33957
           33956 32917 32917 32917)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957)
         #(32917 33957 21508 241308678 241308678 241308678 241308678
           241308678 138250 138250 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957)
         #(32917 32917 33957 32917 33957 32917 33957 32917 33957 32917
           33957 32917 33957 32917 33957 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957)
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 29696 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 29696 29696 35974 50180 50180 50180 17412
           50180 246790 33956 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 33957 33957 33957 33956 33956 214020
           45060 29696 29696 21508 21508 19460 29696 230822918
           241308678 241308678 241308678 241308678 230822918 241308678
           241308678 241308678 232920070 230822918 241308678 241308678
           241308678 241308678 241308678 241308678 230822918 230822918
           230822918 230822918 230822918 230822918 241308678 241308678
           230822918 241308678 241308678 232920070 239211526 241308678
           10622086 11670662 12719238 13767814 14816390 15864966
           16913542 17962118 19010694 20059270 20059270 21107846
           22156422 23204998 12292 24253574)
         #(17412 25302150 26350726 17412 241308806 230823046 17412
           19010694 29696 29696 29696 29696 29696 29696 29696 29696
           495748 495748 495748 495748 495748 495748 495748 495748
           495748 495748 495748 495748 495748 495748 495748 495748
           495748 495748 495748 495748 495748 495748 495748 495748
           495748 495748 495748 29696 29696 29696 29696 495748 495748
           495748 495748 50180 246790 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #(190466 190466 190466 190466 190466 190466 18436 18436 18436
           17412 17412 19460 214020 214020 21508 21508 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 31593606 32642182 33690758 17412 190466 29696
           17412 17412 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(35974 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 28447878 29496454 30545030 31593606 32642182 33690758
           34739334 35787910 241308806 241308806 230823046 230823046
           241308806 241308678 241308806 241308806 241308806 230823046
           241308806 241308806 230823046 73992 73992 73992 73992 73992
           73992 73992 73992 73992 73992 17412 82948 214020 17412 36996
           36996 36836486 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996)
         #0=#(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
              36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
              36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
              36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
              36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
              36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
              36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           17412 36996 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 190466 21508 241308678
           241308678 241308806 241308806 230823046 241308806 35974
           35974 241308806 241308806 21508 230822918 241308678
           241308678 230823046 36996 36996 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 36996 36996 36996 21508
           21508 36996)
         #(17412 17412 17412 17412 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 29696 190466 36996 37885062 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996
           241308806 230823046 241308806 241308806 230823046 241308806
           241308806 230823046 230823046 230823046 241308806 230823046
           230823046 241308806 230823046 241308806)
         #(241308678 241308678 230822918 241308678 230822918 241308678
           230822918 241308678 230822918 241308678 241308678 29696
           29696 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 36996 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 230822918 241308678 35974
           35974 21508 17412 214020 17412 35974 29696 29696 230822918
           19460 19460)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 241308806 241308806 241308678 241308678 35974
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 35974 241308806 241308806
           241308806 35974 241308806 241308806 241308806 241308806
           241308678 29696 29696 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 17412 17412 17412 17412 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 230822918 230822918 230822918
           29696 29696 17412 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696
           230822918 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308678 241308678 190466 230823046 241308806
           241308806 230823046 241308806 241308806 230823046 241308678
           241308678 241308678 230822918 230822918 230822918 28447878
           29496454 30545030 241308806 241308806 241308806 230823046
           241308806 241308806 230823046 230823046 241308806 241308806
           241308806 241308806 241308806)
         #(136326 136326 136326 137352 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 136326
           137352 7476230 36996 137352 137352)
         #(137352 136326 136326 136326 136326 136326 136326 136326
           136326 137352 137352 137352 137352 9573382 137352 137352
           36996 241308678 230822918 241308678 241308678 136326 136326
           136326 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 136326 136326 17412 17412 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 17412 35974 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996)
         #(36996 136326 137352 137352 29696 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 36996 36996 29696 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           29696 36996 29696 29696 29696 36996 36996 36996 36996 29696
           29696 7476230 36996 137352 137352)
         #(137352 136326 136326 136326 136326 29696 29696 137352 137352
           29696 29696 137352 137352 9573382 36996 29696 29696 29696
           29696 29696 29696 29696 29696 137352 29696 29696 29696 29696
           36996 36996 29696 36996 36996 36996 136326 136326 29696
           29696 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 36996 36996 19460 19460 10500 10500 10500 10500 10500
           10500 21508 19460 36996 17412 241308678 29696)
         #(29696 136326 136326 137352 29696 36996 36996 36996 36996
           36996 36996 29696 29696 29696 29696 36996 36996 29696 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 29696 36996 36996 29696 36996 36996 29696
           29696 7476230 29696 137352 137352)
         #(137352 136326 136326 29696 29696 29696 29696 136326 136326
           29696 29696 136326 136326 9573382 29696 29696 29696 136326
           29696 29696 29696 29696 29696 29696 29696 36996 36996 36996
           36996 29696 36996 29696 29696 29696 29696 29696 29696 29696
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           136326 136326 36996 36996 36996 136326 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(29696 136326 136326 137352 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 36996 36996 36996 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 29696 36996 36996 36996 36996 36996 29696
           29696 7476230 36996 137352 137352)
         #(137352 136326 136326 136326 136326 136326 29696 136326
           136326 137352 29696 137352 137352 9573382 29696 29696 36996
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 36996 36996 136326 136326
           29696 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 17412 19460 29696 29696 29696 29696 29696 29696
           29696 36996 136326 136326 136326 136198 136198 136198)
         #(29696 136326 137352 137352 29696 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 36996 36996 29696 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 29696 36996 36996 36996 36996 36996 29696
           29696 7476230 36996 137352 136326)
         #(137352 136326 136326 136326 136326 29696 29696 137352 137352
           29696 29696 137352 137352 9573382 29696 29696 29696 29696
           29696 29696 29696 136198 136326 137352 29696 29696 29696
           29696 36996 36996 29696 36996 36996 36996 136326 136326
           29696 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 21508 36996 10500 10500 10500 10500 10500 10500
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(29696 29696 136326 36996 29696 36996 36996 36996 36996 36996
           36996 29696 29696 29696 36996 36996 36996 29696 36996 36996
           36996 36996 29696 29696 29696 36996 36996 29696 36996 29696
           36996 36996 29696 29696 29696 36996 36996 29696 29696 29696
           36996 36996 36996 29696 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 29696 29696
           29696 29696 137352 137352)
         #(136326 137352 137352 29696 29696 29696 137352 137352 137352
           29696 137352 137352 137352 9573382 29696 29696 36996 29696
           29696 29696 29696 29696 29696 137352 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           10500 10500 10500 21508 21508 21508 21508 21508 21508 19460
           21508 29696 29696 29696 29696 29696)
         #(136326 137352 137352 137352 136198 36996 36996 36996 36996
           36996 36996 36996 36996 29696 36996 36996 36996 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           29696 29696 36996 136326 136326)
         #(136326 137352 137352 137352 137352 29696 136326 136326
           136326 29696 136326 136326 136326 9573382 29696 29696 29696
           29696 29696 29696 29696 88216710 95556742 29696 36996 36996
           36996 29696 29696 29696 29696 29696 36996 36996 136326
           136326 29696 29696 73992 73992 73992 73992 73992 73992 73992
           73992 73992 73992 29696 29696 29696 29696 29696 29696 29696
           17412 10500 10500 10500 10500 10500 10500 10500 21508)
         #(36996 136326 137352 137352 17412 36996 36996 36996 36996
           36996 36996 36996 36996 29696 36996 36996 36996 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 36996 36996 36996 36996 36996 29696
           29696 7476230 36996 137352 136326)
         #(137352 137352 137352 137352 137352 29696 136326 137352
           137352 29696 137352 137352 136326 9573382 29696 29696 29696
           29696 29696 29696 29696 137352 137352 29696 29696 29696
           29696 29696 29696 29696 36996 29696 36996 36996 136326
           136326 29696 29696 73992 73992 73992 73992 73992 73992 73992
           73992 73992 73992 29696 36996 36996 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #(136326 136326 137352 137352 36996 36996 36996 36996 36996
           36996 36996 36996 36996 29696 36996 36996 36996 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           9573382 9573382 36996 137352 137352)
         #(137352 136326 136326 136326 136326 29696 137352 137352
           137352 29696 137352 137352 137352 9573382 36996 21508 29696
           29696 29696 29696 36996 36996 36996 137352 10500 10500 10500
           10500 10500 10500 10500 36996 36996 36996 136326 136326
           29696 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 10500 10500 10500 10500 10500 10500 10500 10500
           10500 21508 36996 36996 36996 36996 36996 36996)
         #(29696 136326 137352 137352 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 29696 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 36996 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
           9573382 29696 29696 29696 29696 137352 137352 137352 136326
           136326 136326 29696 136326 29696 137352 137352 137352 137352
           137352 137352 137352 137352 29696 29696 29696 29696 29696
           29696 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 29696 29696 137352 137352 17412 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(29696 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 136326 4228 4228 136326 136326 136326 136326 108139654
           108139654 9573510 29696 29696 29696 29696 19460)
         #(4228 4228 4228 4228 4228 4228 3206 136198 112333830
           112333830 112333830 112333830 136198 136326 136198 17412
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           17412 17412 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(29696 4228 4228 29696 4228 29696 4228 4228 4228 4228 4228
           29696 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 29696 4228 29696 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 136326 4228 4228 136326 136326 136326 136326
           123868294 123868294 9573382 136326 136326 4228 29696 29696)
         #(4228 4228 4228 4228 4228 29696 3206 29696 128062470
           128062470 128062470 128062470 136198 136326 29696 29696
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 4228 4228 4228 4228 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(36996 21508 21508 21508 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 17412 17412 17412 17412 21508
           17412 21508 21508 21508 230822918 230822918 21508 21508
           21508 21508 21508 21508 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 21508 230822918 21508 230822918
           21508 226628614 13312 14336 13312 14336 137224 137224)
         #(36996 36996 36996 36996 36996 36996 36996 36996 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 29696 29696 29696
           135402630 136451206 136326 138548358 136326 136326 136326
           136326 136326 136451206 136451206 136451206 136451206 136326
           137352)
         #(136451206 136326 241308678 241308678 9573382 17412 241308678
           241308678 36996 36996 36996 36996 36996 136326 136326 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           29696 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 29696 21508 21508)
         #(21508 21508 21508 21508 21508 21508 230822918 21508 21508
           21508 21508 21508 21508 29696 21508 21508 17412 17412 17412
           17412 17412 21508 21508 21508 21508 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696))
       #(#(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 137352 137352 136326
           136326 136326 136326 137352 136326 136326 136326 136326
           136326 7476230 137352 9573382 9573382 137352 137352 136326
           136326 4228)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           17412 17412 17412 17412 17412 17412 4228 4228 4228 4228 4228
           4228 137352 137352 136326 136326 4228 4228 4228 4228 136326
           136326 136326 4228 137352 137352 137352 4228 4228 137352
           137352 137352 137352 137352 137352 137352 4228 4228 4228
           136326 136326 136326 136326 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228)
         #(4228 4228 136326 137352 137352 136326 136326 137352 137352
           137352 137352 137352 137352 230823046 4228 137352 73992
           73992 73992 73992 73992 73992 73992 73992 73992 73992 137352
           137352 137352 136326 21508 21508 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917)
         #(32917 32917 32917 32917 32917 32917 29696 32917 29696 29696
           29696 29696 29696 32917 29696 29696 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 17412
           35974 33957 33957 33957)
         #0# #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 29696 29696 36996 36996 36996 36996
           36996 36996 36996 29696 36996 29696 36996 36996 36996 36996
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 29696 29696 36996 36996 36996 36996
           36996 36996 36996 29696)
         #(36996 29696 36996 36996 36996 36996 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 29696 36996 36996
           36996 36996 29696 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 29696 29696
           241308678 241308678 241308678 17412 17412 17412 17412 17412
           17412 17412 17412 17412 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 29696 29696 29696
           29696 29696 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 29696 29696 33957 33957 33957 33957
           33957 33957 29696 29696)
         #(12292 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #0# #0# #0# #0# #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 21508 17412 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(612864 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 13312 14336 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 17412 17412 17412 42372 42372 42372 36996
           36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 36996 36996 36996 36996 136326
           136326 9573382 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 136326 136326 9573382 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 136326
           136326 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 36996 36996 36996
           29696 136326 136326 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 136198 136198 137352 136326 136326
           136326 136326 136326 136326 136326 137352 137352)
         #(137352 137352 137352 137352 137352 137352 136326 137352
           137352 136198 136198 136198 136198 136198 136198 136198
           136198 136198 9573382 136198 17412 17412 17412 3206 17412
           17412 17412 19460 4228 241308678 29696 29696 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 29696 29696
           29696 29696 29696 29696 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 29696 29696 29696 29696 29696 29696)
         #(17412 17412 17412 17412 17412 17412 12292 17412 17412 17412
           17412 136198 136198 136198 190466 29696 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 29696 29696 29696
           29696 29696 29696 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996)
         #(36996 36996 36996 35974 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 136326 136326 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 239211654 36996 29696 29696 29696 29696 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 136326 136326 136326 137352 137352 137352 137352
           136326 136326 137352 137352 137352 29696 29696 29696 29696
           137352 137352 136326 137352 137352 137352 137352 137352
           137352 232920070 241308678 230822918 29696 29696 29696
           29696)
         #(21508 29696 29696 29696 17412 17412 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 29696 29696 4228 4228 4228 4228 4228 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 29696 29696 29696
           29696 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 29696
           29696 29696 29696 29696 29696 73992 73992 73992 73992 73992
           73992 73992 73992 73992 73992 10500 29696 29696 29696 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 241308806 230823046 137352 137352 136326
           29696 29696 17412 17412 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 137352 136326
           137352 136326 136326 136326 136326 136326 136326 136326
           29696 9573382 137352 136326 137352 137352 136326 136326
           136326 136326 136326 136326 136326 136326 137352 137352
           137352 137352 137352 137352 136326 136326 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 29696 29696 230822918)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 29696 29696 29696 29696 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 29696 29696 29696 29696
           29696 29696 17412 17412 17412 17412 17412 17412 17412 3206
           17412 17412 17412 17412 17412 17412 29696 29696 241308678
           241308678 241308678 241308678 241308678 230822918 230822918
           230822918 230822918 230822918 230822918 241308678 241308678
           230822918 138250 230823046)
         #(230823046 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696)
         #(136326 136326 136326 136326 137352 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 7476230 137352 136326 136326 136326 136326
           136326 137352 136326 137352 137352 137352)
         #(137352 137352 136326 137352 9574408 36996 36996 36996 36996
           36996 36996 36996 29696 29696 29696 29696 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 17412 17412 17412
           17412 17412 17412 17412 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 241308678 230822918 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           21508 21508 21508 21508 21508 21508 21508 21508 21508 29696
           29696 29696)
         #(136326 136326 137352 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 137352 136326 136326 136326 136326
           137352 137352 136326 136326 9574408 9573382 136326 136326
           36996 36996 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 7476230
           137352 136326 136326 137352 137352 137352 136326 137352
           136326 136326 136326 9574408 9574408 29696 29696 29696 29696
           29696 29696 29696 29696 17412 17412 17412 17412)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 137352 137352 137352
           137352 137352 137352 137352 137352 136326 136326 136326
           136326 136326 136326 136326 136326 137352 137352 136326
           7476230 29696 29696 29696 17412 17412 17412 17412 17412)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 29696 36996 36996 36996 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 35974 35974 35974 35974
           35974 35974 17412 17412)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 29696
           29696 29696 29696 29696 29696 29696 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 29696
           29696 32917 32917 32917)
         #(17412 17412 17412 17412 17412 17412 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 241308678 241308678
           241308678 17412 1184774 230822918 230822918 230822918
           230822918 230822918 241308678 241308678 230822918 230822918
           230822918 230822918 241308678 137224 1184774 1184774 1184774
           1184774 1184774 1184774 1184774 36996 36996 36996 36996
           230822918 36996 36996 36996 36996 36996 36996 241308678
           36996 36996 137224 241308678 241308678 36996 29696 29696
           29696 29696 29696)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006)
         #(36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 36006 33957 33956 33956
           33956 33957 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33957 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 36006
           36006 36006 36006 36006)
         #(241308678 241308678 230822918 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 230822918 241308678
           241308678 245502982 224531462 230822918 211948550 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308678
           243405830 239211526 239211526 230822918 29696 241308678
           244454406 230822918 241308678 230822918)
         #1=#(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
              32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
              32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
              32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
              32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
              32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
              32917 33957 32917 33957)
         #1#
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 33956 33956 33956 33956 33956 33957 33956 33956
           32917 33956 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957)
         #1#
         #(33957 33957 33957 33957 33957 33957 33957 33957 32917 32917
           32917 32917 32917 32917 32917 32917 33957 33957 33957 33957
           33957 33957 29696 29696 32917 32917 32917 32917 32917 32917
           29696 29696 33957 33957 33957 33957 33957 33957 33957 33957
           32917 32917 32917 32917 32917 32917 32917 32917 33957 33957
           33957 33957 33957 33957 33957 33957 32917 32917 32917 32917
           32917 32917 32917 32917)
         #(33957 33957 33957 33957 33957 33957 29696 29696 32917 32917
           32917 32917 32917 32917 29696 29696 33956 33957 33956 33957
           33956 33957 33956 33957 29696 32917 29696 32917 29696 32917
           29696 32917 33957 33957 33957 33957 33957 33957 33957 33957
           32917 32917 32917 32917 32917 32917 32917 32917 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 29696 29696)
         #(33957 33957 33957 33957 33957 33957 33957 33957 35013 35013
           35013 35013 35013 35013 35013 35013 33957 33957 33957 33957
           33957 33957 33957 33957 35013 35013 35013 35013 35013 35013
           35013 35013 33957 33957 33957 33957 33957 33957 33957 33957
           35013 35013 35013 35013 35013 35013 35013 35013 33957 33957
           33956 33957 33956 29696 33956 33956 32917 32917 32917 32917
           35013 20486 33957 20486)
         #(20486 20486 33956 33957 33956 29696 33956 33956 32917 32917
           32917 32917 35013 20486 20486 20486 33957 33957 33956 33956
           29696 29696 33956 33956 32917 32917 32917 32917 29696 20486
           20486 20486 33957 33957 33956 33956 33956 33957 33956 33956
           32917 32917 32917 32917 32917 20486 20486 20486 29696 29696
           33956 33957 33956 29696 33956 33956 32917 32917 32917 32917
           35013 20486 20486 29696))
       #(#(612864 612864 612864 612864 612864 612864 612864 23040
           612864 612864 612864 26626 157698 583682 190466 190466 12292
           12292 12292 12292 12292 12292 17412 17412 277506 278530
           13312 15360 15360 16384 13312 15360 17412 17412 17412 17412
           279558 17412 17412 246790 417280 418304 190466 190466 190466
           190466 190466 317952 17412 17412 17412 17412 17412 17412
           17412 17412 17412 15360 16384 17412 17412 17412 17412
           306180)
         #(306180 17412 17412 17412 215044 13312 14336 17412 17412
           17412 17412 17412 17412 17412 17412 17412 17412 17412 18436
           17412 306180 17412 17412 17412 17412 17412 17412 17412 17412
           17412 17412 612864 190466 190466 190466 190466 190466 29696
           190466 190466 190466 190466 190466 190466 190466 190466
           190466 190466 10500 36006 29696 29696 10500 10500 10500
           10500 10500 10500 18436 18436 18436 13312 14336 36006)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           18436 18436 18436 13312 14336 29696 36006 36006 36006 36006
           36006 36006 36006 36006 36006 36006 36006 36006 36006 29696
           29696 29696 19460 19460 19460 19460 19460 19460 19460 19460
           19460 19460 19460 19460 19460 19460 19460 19460 19460 19460
           19460 19460 19460 19460 19460 19460 19460 19460 19460 19460
           19460 19460 19460 19460)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 241308678 241308678
           1184774 1184774 241308678 241308678 241308678 241308678
           1184774 1184774 1184774 241308678 241308678 138250 138250
           138250 138250 241308678 138250 138250 138250 1184774 1184774
           241308678 230822918 241308678 1184774 1184774 230822918
           230822918 230822918 230822918 241308678 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696)
         #(21508 21508 32916 21508 21508 21508 21508 32916 21508 21508
           33956 32916 32916 32916 33956 33956 32916 32916 32916 33956
           21508 32916 21508 21508 18436 32916 32916 32916 32916 32916
           21508 21508 21508 21508 21508 21508 32916 21508 32917 21508
           32916 21508 32917 32917 32916 32916 21508 33956 32916 32916
           32917 32916 33956 36996 36996 36996 36996 33956 21508 21508
           33956 33956 32916 32916)
         #(18436 18436 18436 18436 18436 32916 33956 33956 33956 33956
           21508 18436 21508 21508 33957 21508 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 42389 42389 42389 42389 42389 42389 42389 42389
           42389 42389 42389 42389 42389 42389 42389 42389 42405 42405
           42405 42405 42405 42405 42405 42405 42405 42405 42405 42405
           42405 42405 42405 42405)
         #(42372 42372 42372 32917 33957 42372 42372 42372 42372 10500
           21508 21508 29696 29696 29696 29696 18436 18436 18436 18436
           18436 21508 21508 21508 21508 21508 18436 18436 21508 21508
           21508 21508 18436 21508 21508 18436 21508 21508 18436 21508
           21508 21508 21508 21508 21508 21508 18436 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 18436 18436 21508 21508 18436 21508
           18436 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436)
         #2=#(18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
              18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
              18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
              18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
              18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
              18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
              18436 18436 18436 18436)
         #2# #2# #2#
         #(21508 21508 21508 21508 21508 21508 21508 21508 13312 14336
           13312 14336 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 18436 18436 21508 21508 21508 21508 21508 21508
           21508 13312 14336 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           18436 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 18436 18436
           18436 18436 18436 18436 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 54421 54421 54421 54421 54421 54421
           54421 54421 54421 54421)
         #(54421 54421 54421 54421 54421 54421 54421 54421 54421 54421
           54421 54421 54421 54421 54421 54421 54437 54437 54437 54437
           54437 54437 54437 54437 54437 54437 54437 54437 54437 54437
           54437 54437 54437 54437 54437 54437 54437 54437 54437 54437
           54437 54437 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500)
         #3=#(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508)
         #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 18436 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 18436 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 18436 18436 18436 18436
           18436 18436 18436 18436)
         #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 18436 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #3# #3# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           13312 14336 13312 14336 13312 14336 13312 14336 13312 14336
           13312 14336 13312 14336 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(18436 18436 18436 18436 18436 13312 14336 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 13312 14336
           13312 14336 13312 14336 13312 14336 13312 14336 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436)
         #3# #3# #3# #3# #2# #2#
         #(18436 18436 18436 13312 14336 13312 14336 13312 14336 13312
           14336 13312 14336 13312 14336 13312 14336 13312 14336 13312
           14336 13312 14336 13312 14336 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436)
         #(18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 13312 14336 13312 14336 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           13312 14336 18436 18436)
         #2# #2# #2# #2#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 18436 18436
           18436 18436 18436 18436 18436 18436 18436 18436 18436 18436
           18436 18436 18436 18436)
         #(18436 18436 18436 18436 18436 21508 21508 18436 18436 18436
           18436 18436 18436 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 29696 29696 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 29696 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #3#
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 29696 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 29696 32917 33957 32917 32917 32917 33957 33957 32917
           33957 32917 33957 32917 33957 32917 32917 32917 32917 33956
           32917 33957 33956 32917 33957 33956 33956 33956 33956 33956
           36006 36006 32917 32917)
         #1#
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 33956 21508 21508 21508
           21508 21508 21508 32917 33957 32917 33957 241308678
           241308678 241308678 32917 33957 29696 29696 29696 29696
           29696 17412 17412 17412 17412 10500 17412 17412)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 29696 33957
           29696 29696 29696 29696 29696 33957 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 29696 29696 29696 29696 29696 35974 17412 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 9573382)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 36996 36996 36996 29696 36996 36996
           36996 36996 36996 36996 36996 29696 36996 36996 36996 36996
           36996 36996 36996 29696)
         #(36996 36996 36996 36996 36996 36996 36996 29696 36996 36996
           36996 36996 36996 36996 36996 29696 36996 36996 36996 36996
           36996 36996 36996 29696 36996 36996 36996 36996 36996 36996
           36996 29696 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806)
         #(17412 17412 15360 16384 15360 16384 17412 17412 17412 15360
           16384 17412 15360 16384 17412 17412 17412 17412 17412 17412
           17412 17412 17412 12292 17412 17412 12292 17412 15360 16384
           17412 17412 15360 16384 13312 14336 13312 14336 13312 14336
           13312 14336 17412 17412 17412 17412 17412 35974 17412 17412
           17412 17412 17412 17412 17412 17412 17412 17412 12292 12292
           17412 17412 17412 17412)
         #(12292 17412 13312 17412 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 17412 21508 21508 17412 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #4=#(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
              21508 21508 29696 29696 29696 29696 29696 29696 29696 29696
              29696 29696 29696 29696)
         #3# #3# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           29696 29696 29696 29696))
       #(#(612864 17412 17412 17412 21508 35974 4228 9604 13312 14336
           13312 14336 13312 14336 13312 14336 13312 14336 21508 21508
           13312 14336 13312 14336 13312 14336 13312 14336 12292 13312
           14336 14336 21508 9604 9604 9604 9604 9604 9604 9604 9604
           9604 228725766 239211526 243405830 232920070 235018248
           235018248 12292 101510 101510 101510 101510 101510 21508
           21508 9604 9604 9604 35974 36996 17412 21508 21508)
         #(29696 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 29696
           29696 8524806 8524806 118790 118790 3206 3206 4228 110596
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532)
         #(102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 17412 101510 101510 101510 102532)
         #(29696 29696 29696 29696 29696 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 21508 21508 10500 10500
           10500 10500 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 29696 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 10500 10500
           10500 10500 10500 10500 10500 10500 21508 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 21508)
         #(119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812)
         #(119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           119812 119812 119812 119812 119812 119812 119812 119812
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508)
         #3# #3#
         #5=#(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
              4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
              4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
              4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
              4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
              4228 4228 4228 4228)
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5#)
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #3# #5# #5# #5# #5#
         #5# #5# #5# #5#)
       #6=#(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
            #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
            #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
            #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
            #5# #5# #5# #5#)
       #6# #6# #6#
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 29696 29696 29696))
       #(#(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 35974 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 29696 29696 29696
           29696 29696 29696 29696 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 35974 35974 35974 35974
           35974 35974 17412 17412)
         #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 35974 17412 17412 17412 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 36996 36996 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 36996 241308678 138250
           138250 138250 17412 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308678 241308678
           17412 35974)
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 36006 36006
           241308806 241308806 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 241308678
           241308678 17412 17412 17412 17412 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696)
         #(20486 20486 20486 20486 20486 20486 20486 20486 53254 53254
           53254 53254 53254 53254 53254 53254 53254 53254 53254 53254
           53254 53254 53254 35974 35974 35974 35974 35974 35974 35974
           35974 35974 53254 53254 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 33956 33956
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957)
         #(32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 36006 33956
           33956 33956 33956 33956 33956 33956 33956 32917 33957 32917
           33957 32917 32917 33957)
         #(32917 33957 32917 33957 32917 33957 32917 33957 35974 53254
           53254 32917 33957 32917 33956 36996 32917 33957 32917 33957
           33957 33956 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 32917 32917 32917 32917 33956 32917 32917
           32917 32917 32917 33957 32917 33957 32917 33957 32917 33957
           32917 33957 32917 33957)
         #(29696 29696 32917 33957 32917 32917 32917 32917 33957 32917
           33957 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 32917 33957 36996 36006 36006 33956 36996
           36996 36996 36996 36996)
         #(36996 36996 136326 36996 36996 36996 9573382 36996 36996
           36996 36996 136326 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 137352 137352 136326
           136326 137352 21508 21508 21508 21508 9573382 29696 29696
           29696 10500 10500 10500 10500 10500 10500 21508 21508 19460
           21508 29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 17412 17412 17412 17412 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(137352 137352 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 137352 137352 137352 137352 137352 137352
           137352 137352 137352 137352 137352 137352)
         #(137352 137352 137352 137352 9573382 136326 29696 29696 29696
           29696 29696 29696 29696 29696 17412 17412 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 29696 29696 29696
           29696 29696 29696 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 36996 36996 36996 36996 36996 36996
           17412 17412 17412 36996 17412 36996 36996 136326)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 136326
           136326 136326 136326 136326 230822918 230822918 230822918
           17412 17412 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 136326 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 137352 9574408 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 17412 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 29696 29696)
         #(136326 136326 136326 137352 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 7476230 137352 137352 136326 136326 136326
           136326 137352 137352 136326 136326 137352 137352)
         #(9574408 17412 17412 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 29696 35974 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 29696 29696 29696
           29696 17412 17412 4228 4228 4228 4228 4228 136326 3206 4228
           4228 4228 4228 4228 4228 4228 4228 4228 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 4228 4228 4228
           4228 4228 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 136326 136326 136326 136326 136326 136326 137352
           137352 136326 136326 137352 137352 136326 136326 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 136326 36996 36996 36996 36996 36996 36996
           36996 36996 136326 137352 29696 29696 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 29696 29696 17412
           17412 17412 17412 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 3206 4228 4228 4228
           4228 4228 4228 21508 21508 21508 4228 137352 136326 137352
           4228 4228)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           241308806 4228 241308806 241308806 230823046 4228 4228
           241308806 241308806 4228 4228 4228 4228 4228 241308806
           241308678)
         #(4228 241308678 4228 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 4228 4228
           3206 17412 17412 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 137352 136326 136326 137352 137352
           17412 17412 36996 35974 35974 137352 9573382 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(29696 36996 36996 36996 36996 36996 36996 29696 29696 36996
           36996 36996 36996 36996 36996 29696 29696 36996 36996 36996
           36996 36996 36996 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 36996 36996 36996 29696 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33957
           33956 33956 33956 33956 33956 33956 33956 53254 36006 36006
           36006 36006 33956 33956 33956 33956 33956 33956 33956 33956
           33956 35974 20486 20486 29696 29696 29696 29696 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 137352 137352 136326 137352
           137352 136326 137352 137352 17412 137224 9573382 29696 29696
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 29696 29696 29696 29696)
         #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #0#)
       #7=#(#0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
            #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
            #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
            #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
            #0# #0# #0# #0#)
       #7#
       #(#0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
           29696 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 29696 29696)
         #8=#(27648 27648 27648 27648 27648 27648 27648 27648 27648 27648
              27648 27648 27648 27648 27648 27648 27648 27648 27648 27648
              27648 27648 27648 27648 27648 27648 27648 27648 27648 27648
              27648 27648 27648 27648 27648 27648 27648 27648 27648 27648
              27648 27648 27648 27648 27648 27648 27648 27648 27648 27648
              27648 27648 27648 27648 27648 27648 27648 27648 27648 27648
              27648 27648 27648 27648)
         #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8#
         #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8# #8#
         #8#)
       #9=#(#10=#(28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676 28676 28676 28676 28676 28676 28676 28676 28676
                  28676)
            #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
            #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
            #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
            #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
            #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
            #10# #10# #10#)
       #(#10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
         #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
         #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
         #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4484 4228 4228 4228 4228
           4228 4228 4228 4484 4228 4228 4228 4228 4484 4228 4228 4228
           4228 4228 4228 4228)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4484 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4484 4228 4484 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4484 4228 4228)
         #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 29696
           29696 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228)
         #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #(33956 33956 33956 33956 33956 33956 33956 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 33956
           33956 33956 33956 33956 29696 29696 29696 29696 29696 495748
           27399302 495748 495748 495748 495748 495748 495748 495748
           495748 495748 495748 18436 495748 495748 495748 495748
           495748 495748 495748 495748 495748 495748 495748 495748
           495748 29696 495748 495748 495748 495748 495748 29696 495748
           29696)
         #(495748 495748 29696 495748 495748 29696 495748 495748 495748
           495748 495748 495748 495748 495748 495748 495748 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           20486 20486 20486 20486 20486 20486 20486 20486 20486 20486
           20486 20486 20486 20486)
         #(20486 20486 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 14336 13312)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           19460 21508 29696 29696)
         #(136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           214020 17412 17412 246790 214020 17412 17412 13312 14336
           17412 29696 29696 29696 29696 29696 29696 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           230822918 230822918 230822918 230822918 230822918 230822918
           230822918 241308678 241308678 17412 12292 12292 306180
           306180 13312 14336 13312 14336 13312 14336 13312 14336 13312
           14336 13312)
         #(14336 13312 14336 13312 14336 17412 17412 13312 14336 17412
           17412 17412 17412 306180 306180 306180 214020 17412 279558
           29696 214020 246790 17412 17412 12292 13312 14336 13312
           14336 13312 14336 17412 17412 17412 18436 12292 18436 18436
           18436 29696 17412 19460 17412 17412 29696 29696 29696 29696
           36996 36996 36996 36996 36996 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996)
         #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 29696 190466)
         #(29696 17412 17412 17412 19460 17412 17412 279558 13312 14336
           17412 18436 214020 12292 279558 17412 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 246790 214020
           18436 18436 18436 17412 17412 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 13312 17412 14336 20486 306180)
         #(20486 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 13312 18436 14336
           18436 13312 14336 17412 13312 14336 17412 17412 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 101510 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532)
         #(102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 102532 102532
           102532 102532 102532 102532 102532 102532 134278 134278
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696)
         #(29696 29696 36996 36996 36996 36996 36996 36996 29696 29696
           36996 36996 36996 36996 36996 36996 29696 29696 36996 36996
           36996 36996 36996 36996 29696 29696 36996 36996 36996 29696
           29696 29696 19460 19460 18436 20486 21508 19460 19460 29696
           21508 18436 18436 18436 18436 21508 21508 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 190466 190466
           190466 21508 21508 29696 29696))
       #(#(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 29696 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           29696 29696 29696 29696)
         #(17412 17412 17412 29696 29696 29696 29696 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 29696 29696 29696 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 10500 10500 10500 10500 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           10500 10500 21508 21508 21508 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 29696
           29696 29696 21508 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 230822918 29696 29696)
         #11=#(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696)
         #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 230822918 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 10500 10500 10500 10500 29696 29696 29696 29696
           29696 29696 29696 29696 29696 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 42372 36996 36996 36996 36996 36996 36996 36996 36996
           42372 29696 29696 29696 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 241308806 241308806 241308806
           241308806 241308806 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 17412 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 17412 42372 42372 42372
           42372 42372 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 29696 29696 29696 29696 29696 29696 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           29696 29696 29696 29696 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 29696 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11#
         #(36996 36996 36996 36996 36996 36996 29696 29696 36996 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 29696 36996 36996 29696 29696 29696
           36996 29696 29696 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 17412 10500 10500 10500 10500 10500 10500
           10500 10500 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 21508 21508 10500 10500 10500
           10500 10500 10500 10500)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 29696 29696 29696 29696 29696 29696 29696 10500
           10500 10500 10500 10500 10500 10500 10500 10500 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 36996 36996 29696 29696 29696 29696 29696 10500
           10500 10500 10500 10500)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 10500 10500 10500 10500 10500 10500 29696 29696
           29696 17412 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 29696 29696
           29696 29696 29696 17412)
         #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 29696 29696
           10500 10500 36996 36996)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 29696 29696 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500)
         #(36996 136326 136326 136326 29696 136326 136326 29696 29696
           29696 29696 29696 136326 230823046 136326 241308806 36996
           36996 36996 36996 29696 36996 36996 36996 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 29696 29696
           241308678 1184774 230822918 29696 29696 29696 29696 9573382)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 29696
           29696 29696 29696 29696 29696 29696 17412 17412 17412 17412
           17412 17412 17412 17412 17412 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 10500 10500 17412)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 10500
           10500 10500 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 21508 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 241308678
           230822918 29696 29696 29696 29696 10500 10500 10500 10500
           10500 17412 17412 17412 17412 17412 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 29696 17412 17412 17412
           17412 17412 17412 17412)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 29696 10500 10500 10500 10500 10500 10500
           10500 10500 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 29696 29696 29696 29696 10500 10500 10500 10500
           10500 10500 10500 10500)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 29696 29696
           29696 29696 29696 29696 29696 17412 17412 17412 17412 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 10500 10500 10500 10500 10500 10500 10500 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 29696 29696 29696 29696 29696 29696 29696 10500 10500
           10500 10500 10500 10500)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 241308806 241308806
           241308806 241308806 29696 29696 29696 29696 29696 29696
           29696 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 241308806 241308806 12292 29696 29696
           36996 36996 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 36996
           29696 29696 29696 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 230822918 230822918
           241308678 241308678 241308678 230822918 241308678 230822918
           230822918 230822918 230822918 10500 10500 10500 10500 17412
           17412 17412 17412 17412 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 10500 10500 10500 10500 10500
           10500 10500 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 29696 29696 29696 29696
           29696 29696 29696 29696))
       #(#(137352 136326 137352 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 136326 136326
           136326 136326 136326 136326 136326 136326)
         #(136326 136326 136326 136326 136326 136326 9573382 17412
           17412 17412 17412 17412 17412 17412 29696 29696 29696 29696
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 9573382)
         #(136198 136198 137352 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 137352
           137352 137352 136326 136326 136326 136326 137352 137352
           9573382 7476230 17412 17412 190466 17412 17412)
         #(17412 17412 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 190466 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 29696 29696 29696 29696 29696 29696 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 29696 29696
           29696 29696 29696 29696)
         #(241308806 241308806 241308806 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 136326 136326 136326 136326 136326 137352 136326
           136326 136326 136326 136326 136326 9573382 9573382 29696
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992)
         #(17412 17412 17412 17412 36996 137352 137352 36996 29696
           29696 29696 29696 29696 29696 29696 29696 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 7476230 17412 17412 36996 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #(136326 136326 137352 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 137352 137352 137352 136326 136326 136326 136326
           136326 136326 136326 136326 136326 137352)
         #(9574408 36996 36996 36996 36996 17412 17412 17412 17412
           136198 7476230 136198 136198 17412 137352 136326 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 36996 17412
           36996 17412 17412 17412 29696 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 29696 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 137352 137352 137352 136326 136326
           136326 137352 137352 136326 9574408 7476230 136326 17412
           17412 17412 17412 17412 17412 136326 29696)
         #11#
         #(36996 36996 36996 36996 36996 36996 36996 29696 36996 29696
           36996 36996 36996 36996 29696 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 17412 29696 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 136326 137352 137352 137352 136326 136326 136326
           136326 136326 136326 7476230 9573382 29696 29696 29696 29696
           29696 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 29696 29696 29696 29696 29696 29696)
         #(136326 136326 137352 137352 29696 36996 36996 36996 36996
           36996 36996 36996 36996 29696 29696 36996 36996 29696 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 29696 36996 36996 36996 36996 36996 29696
           7476230 7476230 36996 137352 137352)
         #(136326 137352 137352 137352 137352 29696 29696 137352 137352
           29696 29696 137352 137352 9574408 29696 29696 36996 29696
           29696 29696 29696 29696 29696 137352 29696 29696 29696 29696
           29696 36996 36996 36996 36996 36996 137352 137352 29696
           29696 241308678 241308678 241308678 241308678 241308678
           241308678 241308678 29696 29696 29696 241308678 241308678
           241308678 241308678 241308678 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #11# #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 137352 137352 137352 136326 136326 136326
           136326 136326 136326 136326 136326)
         #(137352 137352 9573382 136326 136326 137352 7476230 36996
           36996 36996 36996 17412 17412 17412 17412 17412 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 17412 17412
           29696 17412 241308678 36996 36996 36996 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 137352
           137352 137352 136326 136326 136326 136326 136326 136326
           137352 136326 137352 137352 137352 137352 136326)
         #(136326 137352 9573382 7476230 36996 36996 17412 36996 29696
           29696 29696 29696 29696 29696 29696 29696 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696)
         #11# #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 137352 137352
           137352 136326 136326 136326 136326 29696 29696 137352 137352
           137352 137352 136326 136326 137352 9573382)
         #(7476230 17412 17412 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 36996 36996 36996 36996 136326
           136326 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 137352
           137352 137352 136326 136326 136326 136326 136326 136326
           136326 136326 137352 137352 136326 137352 9573382)
         #(136326 17412 17412 17412 36996 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 29696 29696 29696 29696
           29696 29696 17412 17412 17412 17412 17412 17412 17412 17412
           17412 17412 17412 17412 17412 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 136326 137352 136326 137352 137352 136326
           136326 136326 136326 136326 136326 9574408 7476230 36996
           29696 29696 29696 29696 29696 29696 29696)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 29696 29696 136326 136326 136326 137352
           137352 136326 136326 136326 136326 137352 136326 136326
           136326 136326 9573382 29696 29696 29696 29696 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 10500 10500
           17412 17412 17412 21508)
         #11# #11# #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 137352 137352 137352 136326 136326
           136326 136326 136326 136326 136326 136326 136326 137352
           9573382 7476230 17412 29696 29696 29696 29696)
         #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917)
         #(33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 10500 10500 10500 10500 10500 10500 10500 10500
           10500 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 36996)
         #(36996 36996 36996 36996 36996 36996 36996 29696 29696 36996
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 137352
           137352 137352 137352 137352 137352 29696 137352 137352 29696
           29696 136326 136326 9574408 9573382 36996)
         #(137352 36996 137352 7476230 17412 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 137352 137352
           137352 136326 136326 136326 136326 29696 29696 136326 136326
           137352 137352 137352 137352 9573382 36996 17412 36996 137352
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(36996 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 136198 9573382 136326 136326 136326
           136326 137352 36996 136326 136326 136326 136326 17412)
         #(17412 17412 17412 17412 17412 17412 17412 9573382 29696
           29696 29696 29696 29696 29696 29696 29696 36996 136326
           136326 136326 136326 136326 136326 137352 137352 136326
           136326 136326 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 137352 136198 9573382
           17412 17412 17412 36996 17412 17412 17412 17412 17412 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #12=#(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
               36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
               36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
               36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
               36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
               36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
               29696 29696 29696 29696)
         #11# #11# #11# #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 137352 136326
           136326 136326 136326 136326 136326 136326 29696 136326
           136326 136326 136326 136326 136326 137352 9573382)
         #(36996 17412 17412 17412 17412 17412 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 29696 29696 29696 17412 17412
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 136326 136326 136326
           136326 136326 136326 136326 136326 29696 137352 136326
           136326 136326 136326 136326 136326 136326 137352 136326
           136326 137352 136326 136326 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11#
         #(36996 36996 36996 36996 36996 36996 36996 29696 36996 36996
           29696 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 136326
           136326 136326 136326 136326 136326 29696 29696 29696 136326
           29696 136326 136326 29696 136326)
         #(136326 136326 7476230 136326 9573382 9573382 36996 136326
           29696 29696 29696 29696 29696 29696 29696 29696 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 29696 29696
           29696 29696 29696 29696 36996 36996 36996 36996 36996 36996
           29696 36996 36996 29696 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           137352 137352 137352 137352 137352 29696 136326 136326 29696
           137352 137352 136326 137352 9573382 36996 29696 29696 29696
           29696 29696 29696 29696 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 136326 136326 137352 137352 17412 17412 29696 29696
           29696 29696 29696 29696 29696)
         #11# #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 36996 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 21508 21508 21508 21508 21508 21508 21508 21508 19460
           19460 19460 19460 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 17412))
       #(#0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11#
         #(42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372)
         #(42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 42372 42372 42372
           42372 42372 42372 42372 42372 42372 42372 29696 17412 17412
           17412 17412 17412 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #0# #0# #0#
         #(36996 36996 36996 36996 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11#)
       #(#0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 29696 190466
           190466 190466 190466 190466 190466 190466 190466 190466
           29696 29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#)
       #(#11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #0# #0# #0# #0# #0# #0# #0# #0# #0#
         #(36996 36996 36996 36996 36996 36996 36996 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11#)
       #13=#(#11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
             #11# #11# #11# #11#)
       #(#11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #0# #0# #0# #0# #0#
         #0# #0# #0# #12#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 29696 29696 29696 29696 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 1184774
           1184774 1184774 1184774 1184774 17412 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           17412 17412 17412 17412 17412 21508 21508 21508 21508)
         #(35974 35974 35974 35974 17412 21508 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 29696 10500 10500 10500
           10500 10500 10500 10500 29696 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 29696 29696
           29696 36996 36996 36996)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 17412 17412 17412 17412 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 29696 29696 29696 136326 36996 137352 137352
           137352 137352 137352 137352 137352 137352 137352 137352
           137352 137352 137352 137352 137352 137352 137352 137352
           137352 137352 137352 137352 137352 137352 137352 137352
           137352 137352 137352 137352 137352 137352 137352 137352
           137352 137352 137352 137352 137352 137352 137352 137352
           137352 137352 137352 137352 137352)
         #(137352 137352 137352 137352 137352 137352 137352 137352
           29696 29696 29696 29696 29696 29696 29696 136326 136326
           136326 136326 35974 35974 35974 35974 35974 35974 35974
           35974 35974 35974 35974 35974 35974 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 35974 35974 17412 35974 136198 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 6428808
           6428808 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696))
       #6#
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 29696 29696 29696
           29696 29696 29696 29696 29696)
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696)
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#)
       #13# #13#
       #(#(102532 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228)
         #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 4228 4228 4228 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 102532 102532 102532
           102532 29696 29696 29696 29696 29696 29696 29696 29696 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228)
         #5# #5# #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #0#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 29696 29696 29696 29696 29696 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 29696 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 29696
           29696 29696 29696 29696 29696 29696 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 29696 29696 21508 136198
           1184902 17412 190466 190466 190466 190466 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11#)
       #13#
       #(#3# #3# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 29696
           29696 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 226629640
           226629640 1184774 1184774 1184774 21508 21508 21508
           237115400 226629640 226629640 226629640 226629640 226629640
           190466 190466 190466 190466 190466 190466 190466 190466
           230822918 230822918 230822918 230822918 230822918)
         #(230822918 230822918 230822918 21508 21508 241308678
           241308678 241308678 241308678 241308678 230822918 230822918
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           241308678 241308678 241308678 241308678 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #3#
         #(21508 21508 241308678 241308678 241308678 21508 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 29696 29696 29696 29696 29696 29696 29696
           29696 29696 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11#
         #(32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916)
         #(32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 33956 33956 33956 33956 33956 33956
           33956 29696 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916)
         #(32916 32916 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 32916 29696
           32916 32916 29696 29696 32916 29696 29696 32916 32916 29696
           29696 32916 32916 32916 32916 29696 32916 32916 32916 32916
           32916 32916 32916 32916 33956 33956 33956 33956 29696 33956
           29696 33956 33956 33956)
         #(33956 33956 33956 33956 29696 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 32916 32916 29696 32916 32916 32916
           32916 29696 29696 32916 32916 32916 32916 32916 32916 32916
           32916 29696 32916 32916 32916 32916 32916 32916 32916 29696
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 32916 32916 29696 32916
           32916 32916 32916 29696)
         #(32916 32916 32916 32916 32916 29696 32916 29696 29696 29696
           32916 32916 32916 32916 32916 32916 32916 29696 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916)
         #(32916 32916 32916 32916 32916 32916 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           32916 32916 32916 32916)
         #(32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916)
         #(32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 29696 29696
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916)
         #(32916 18436 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 18436 33956 33956
           33956 33956 33956 33956 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 18436
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 18436 33956 33956 33956 33956 33956 33956 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 18436 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 18436 33956 33956 33956 33956
           33956 33956 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 18436 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 33956 33956 33956 33956 33956 33956 18436
           33956 33956 33956 33956 33956 33956 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 32916 32916 32916 32916 32916 32916 32916 32916 32916
           32916 18436 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956 33956 33956 33956 33956 33956 33956
           33956 33956 33956 33956)
         #(33956 33956 33956 18436 33956 33956 33956 33956 33956 33956
           32916 33956 29696 29696 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 73992 73992)
         #3# #3# #3# #3# #3# #3# #3# #3#
         #(136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 21508 21508
           21508 21508 136198 136198 136198 136198 136198)
         #(136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 21508 21508 21508 21508
           21508 21508 21508 21508 136198 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508)
         #(21508 21508 21508 21508 136198 21508 21508 17412 17412 17412
           17412 17412 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 136198 136198
           136198 136198 136198 29696 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11#)
       #(#(241308806 241308806 241308806 241308806 241308806 241308806
           241308806 29696 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 241308806 241308806
           241308806 29696 29696 241308806 241308806 241308806
           241308806 241308806 241308806 241308806 29696 241308806
           241308806 29696 241308806 241308806 241308806 241308806
           241308806 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696)
         #11# #11# #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 29696 29696 29696 241308678
           241308678 241308678 241308678 241308678 241308678 241308678
           35974 35974 35974 35974 35974 35974 35974 29696 29696)
         #(73992 73992 73992 73992 73992 73992 73992 73992 73992 73992
           29696 29696 29696 29696 36996 21508 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #11# #11# #11#
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 241308678 241308678 241308678
           241308678 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 29696 29696 29696 29696 29696 19460)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #0# #0# #0#
         #(36996 36996 36996 36996 36996 29696 29696 10500 10500 10500
           10500 10500 10500 10500 10500 10500 230822918 230822918
           230822918 230822918 230822918 230822918 230822918 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #(32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 32917 32917 32917 32917 32917 32917
           32917 32917 32917 32917 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957 33957 33957 33957 33957 33957 33957
           33957 33957 33957 33957)
         #(33957 33957 33957 33957 241308678 241308678 241308678
           241308806 241308678 241308678 7476230 35974 29696 29696
           29696 29696 73992 73992 73992 73992 73992 73992 73992 73992
           73992 73992 29696 29696 29696 29696 17412 17412 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 21508 10500 10500 10500 19460 10500
           10500 10500 10500 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11#
         #(29696 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 10500 10500 10500 21508 10500 10500 10500
           10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 29696 29696)
         #11# #11# #11#
         #(36996 36996 36996 36996 29696 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 29696 36996 36996 29696 36996 29696 29696 36996
           29696 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 29696 36996 36996 36996 36996 29696 36996 29696 36996
           29696 29696 29696 29696)
         #(29696 29696 36996 29696 29696 29696 29696 36996 29696 36996
           29696 36996 29696 36996 36996 36996 29696 36996 36996 29696
           36996 29696 29696 36996 29696 36996 29696 36996 29696 36996
           29696 36996 29696 36996 36996 29696 36996 29696 29696 36996
           36996 36996 36996 29696 36996 36996 36996 36996 36996 36996
           36996 29696 36996 36996 36996 36996 29696 36996 36996 36996
           36996 29696 36996 29696)
         #(36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 36996 36996 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 29696 29696
           29696 29696 29696 36996 36996 36996 29696 36996 36996 36996
           36996 36996 29696 36996 36996 36996 36996 36996 36996 36996
           36996 36996 36996 36996 36996 36996 36996 36996 36996 36996
           29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 18436 18436
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #11# #11#)
       #(#(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 29696 29696 29696 29696 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 29696 29696 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(29696 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(10500 10500 10500 10500 10500 10500 10500 10500 10500 10500
           10500 10500 10500 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 54420 54420
           54420 54420 54420 54420 54420 54420 54420 54420 54420 54420
           54420 54420 54420 54420)
         #(54420 54420 54420 54420 54420 54420 54420 54420 54420 54420
           21508 21508 21508 21508 21508 21508 54420 54420 54420 54420
           54420 54420 54420 54420 54420 54420 54420 54420 54420 54420
           54420 54420 54420 54420 54420 54420 54420 54420 54420 54420
           54420 54420 21508 21508 21508 21508 21508 21508 54420 54420
           54420 54420 54420 54420 54420 54420 54420 54420 54420 54420
           54420 54420 54420 54420)
         #(54420 54420 54420 54420 54420 54420 54420 54420 54420 54420
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 545796
           545796 545796 545796 545796 545796 545796 545796 545796
           545796 545796 545796 545796 545796 545796 545796 545796
           545796 545796 545796 545796 545796 545796 545796 545796
           545796)
         #(21508 21508 21508 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           29696 29696 29696 29696)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 29696
           29696 29696 29696 29696 29696 29696 21508 21508 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 21508 21508 21508 21508 21508 21508 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #11# #3# #3# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 151558
           151558 151558 151558 151558)
         #3# #3# #3# #3# #3# #3# #3# #3# #3# #3# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 29696 29696 29696 29696 29696 29696
           29696 29696 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 29696 29696 29696 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 29696 29696 29696)
         #3# #4# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 29696 29696 29696 29696 29696
           29696 29696 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 29696 29696
           29696 29696 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 29696 29696 29696
           29696 29696 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 29696 29696
           29696 29696 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 29696 21508 21508
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #11# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 29696 21508 21508
           21508 21508 21508 21508)
         #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 29696 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 29696 29696 21508 21508
           21508 21508 21508 29696 29696 29696 21508 21508 21508 29696
           29696 29696 29696 29696)
         #(21508 21508 21508 21508 21508 21508 21508 29696 29696 29696
           29696 29696 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 29696 29696 29696 29696 29696 29696 29696 21508 21508
           21508 21508 21508 21508 21508 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #(21508 21508 21508 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 21508 21508 21508 21508
           21508 21508 21508 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696)
         #3# #3#
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 29696
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 21508 21508 21508)
         #(21508 21508 21508 21508 21508 21508 21508 21508 21508 21508
           21508 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 73992 73992
           73992 73992 73992 73992 73992 73992 73992 73992 29696 29696
           29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11#)
       #6# #6# #6# #6# #6# #6# #6# #6# #6# #6#
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #14=#(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
               4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
               4228 4228 4228 4228 4228 4228 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
               29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5#)
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696)
         #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 29696 29696 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228)
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5#)
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228)
         #5# #5# #5# #5# #5#)
       #6#
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11#)
       #(#11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4484 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228
           4228 4228 4228 4228)
         #5# #5# #5# #5# #5# #14# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11#)
       #6#
       #(#5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5# #5#
         #(4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 4228 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11#)
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #13# #13# #13#
       #(#(29696 190466 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698)
         #(157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698
           157698 157698 157698 157698 157698 157698 157698 157698)
         #11# #11#
         #15=#(136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198
               136198 136198 136198 136198 136198 136198 136198 136198)
         #15# #15#
         #(136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           136198 136198 136198 136198 136198 136198 136198 136198
           29696 29696 29696 29696 29696 29696 29696 29696 29696 29696
           29696 29696 29696 29696 29696 29696)
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11# #11#
         #11# #11# #11# #11# #11# #11# #11# #11#)
       #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13# #13#
       #13# #13# #13# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9#
       #9# #9# #9# #9#
       #16=#(#10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
             #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
             #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
             #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
             #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10# #10#
             #10# #10# #10#
             #(28676 28676 28676 28676 28676 28676 28676 28676 28676 28676
               28676 28676 28676 28676 28676 28676 28676 28676 28676 28676
               28676 28676 28676 28676 28676 28676 28676 28676 28676 28676
               28676 28676 28676 28676 28676 28676 28676 28676 28676 28676
               28676 28676 28676 28676 28676 28676 28676 28676 28676 28676
               28676 28676 28676 28676 28676 28676 28676 28676 28676 28676
               28676 28676 29696 29696))
       #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9# #9#
       #16#))
  (define unicode-category-names
    '#(Lu Ll Lt Lm Lo Mn Mc Me Nd Nl No Pc Pd Ps Pe Pi Pf Po Sm
       Sc Sk So Zs Zl Zp Cc Cf Cs Co Cn))
  (define table-ref
    (lambda (tbl i)
      (let ([#17=g3 (* 64 64)])
        (let ([#18=g4 (* 64)])
          (vector-ref
            (vector-ref
              (vector-ref tbl (fxdiv i #17#))
              (fxdiv (fxmod i #17#) #18#))
            (fxmod (fxmod i #17#) #18#))))))
  (define (getprop n) (table-ref unicode-category-table n))
  (define $char-constituent?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 4)))
  (define $char-subsequent?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 8)))
  (define $char-upper-case?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 16)))
  (define $char-lower-case?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 32)))
  (define $char-title-case?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 64)))
  (define $char-alphabetic?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 128)))
  (define $char-numeric?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 256)))
  (define $char-whitespace?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 512)))
  (define $char-cased?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 1)))
  (define $char-case-ignorable?
    (lambda (c) (fxlogtest (getprop (char->integer c)) 2)))
  (define (wb prop)
    (lambda (c)
      (fx= (fxand (fxsrl (getprop (char->integer c)) 15) 31)
           prop)))
  (define $wb-aletter? (wb 1))
  (define $wb-numeric? (wb 2))
  (define $wb-katakana? (wb 3))
  (define $wb-extend? (wb 4))
  (define $wb-format? (wb 5))
  (define $wb-midnum? (wb 6))
  (define $wb-midletter? (wb 7))
  (define $wb-midnumlet? (wb 8))
  (define $wb-extendnumlet? (wb 9))
  (define $wb-hebrew-letter? (wb 15))
  (define $wb-double-quote? (wb 13))
  (define $wb-single-quote? (wb 14))
  (define $wb-regional-indicator? (wb 16))
  (define $wb-zwj? (wb 17))
  (define $wb-wsegspace? (wb 18))
  (define $char-combining-class
    (lambda (c)
      (fxand (fxsrl (getprop (char->integer c)) 20) 255)))
  (define $char-category
    (lambda (c)
      (vector-ref
        unicode-category-names
        (fxand (fxsrl (getprop (char->integer c)) 10) 31))))
  (define $char-dump
    (lambda (c)
      (define (list-true . args) (remq #f args))
      (list-true (and ($char-constituent? c) 'constituent)
       (and ($char-subsequent? c) 'subsequent)
       (and ($char-upper-case? c) 'upper-case)
       (and ($char-lower-case? c) 'lower-case)
       (and ($char-title-case? c) 'title-case)
       (and ($char-alphabetic? c) 'alphabetic)
       (and ($char-numeric? c) 'whitespace)
       (and ($char-whitespace? c) 'whitespace)
       (and ($char-cased? c) 'cased)
       (and ($char-case-ignorable? c) 'case-ignorable)
       (and ($wb-aletter? c) 'aletter)
       (and ($wb-numeric? c) 'numeric)
       (and ($wb-katakana? c) 'katakana)
       (and ($wb-extend? c) 'extend) (and ($wb-format? c) 'format)
       (and ($wb-midnum? c) 'midnum)
       (and ($wb-midletter? c) 'midletter)
       (and ($wb-midnumlet? c) 'midnumlet)
       (and ($wb-extendnumlet? c) 'extendnumlet)
       (and ($wb-hebrew-letter? c) 'hebrew-letter)
       (and ($wb-double-quote? c) 'double-quote)
       (and ($wb-single-quote? c) 'single-quote)
       (and ($wb-regional-indicator? c) 'regional-indicator)
       `(combining-class ,($char-combining-class c))
       ($char-category c)))))
