;; -*- mode: scheme; coding: utf-8 -*-
;; SPDX-License-Identifier: AGPL-3.0-or-later
;; Loko Scheme - an R6RS Scheme compiler
;; Copyright © 2019, 2020 Göran Weinholt

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU Affero General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU Affero General Public License for more details.

;; You should have received a copy of the GNU Affero General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.
#!r6rs

;;; Register the target for Loko on any target

(library (loko arch amd64 polyglot-asm)
  (export visit)
  (import
    (rnrs (6))
    (loko arch asm)
    (prefix (loko arch amd64 pc-start) amd64-pc-start:)
    (prefix (loko arch amd64 elf-start) amd64-elf-start:)
    (prefix (loko arch amd64 linux-start) amd64-linux-start:)
    (prefix (loko arch amd64 netbsd-start) amd64-netbsd-start:)
    (prefix (loko arch amd64 lib) amd64:)
    (prefix (loko arch amd64 codegen) amd64:)
    (prefix (loko arch amd64 analyzer) amd64:)
    (prefix (loko arch amd64 tables) amd64:))

(define (visit) #f)

(define (loko-assembler-library target-cpu target-kernel notice text data)
  (append '((%origin #x200000)
            (%label image-address-zero))
          (amd64-elf-start:image-header)
          notice
          (amd64-pc-start:image-header 'image-address-zero)
          (amd64:text-start)
          (amd64-pc-start:text-start)
          (amd64-elf-start:text-start)
          (amd64:text)
          (amd64-elf-start:text)
          (amd64-pc-start:text)
          (amd64-linux-start:text)
          (amd64-netbsd-start:text)
          text
          (amd64:text-end)
          (amd64:data-start)
          (amd64:data)
          (amd64-elf-start:data)
          (amd64-linux-start:data)
          (amd64-netbsd-start:data)
          (amd64-pc-start:data)
          data
          (amd64:data-end)
          (amd64-elf-start:image-footer)))

(register-target 'amd64 'polyglot
                 amd64:assemble
                 amd64:codegen
                 amd64:instruction-analyzer
                 amd64:target-convention
                 amd64:table-generator
                 loko-assembler-library))
